define('jira-agile/rapid/versions-data-service', ['jira-agile/rapid/ajax', 'underscore'], function(Ajax, _) {
    function VersionsDataService() { }

    /**
     * Get a GH.VersionsModel representing the versions for the rapidViewId.
     *
     * @param {number} rapidViewId
     * @returns {Promise}
     */
    VersionsDataService.prototype.getVersionsModel = function(rapidViewId) {
        return Ajax.get({
            url: '/xboard/plan/backlog/versions.json',
            data: { rapidViewId: rapidViewId }
        }, 'versionsList').andThen(function(data) {
            var model = new GH.VersionsModel(data.projects);
            model.updateRawData(data.versionData);
            return model;
        });
    };

    /**
     * Get the versions for the rapidViewId.
     * The returned versions are in the form: { id: number, name: string }.
     * The version name is prefixed with the project key, if available.
     *
     * @param {number} rapidViewId
     * @returns {Promise}
     */
    VersionsDataService.prototype.getSimpleVersions = function(rapidViewId) {
        return this.getVersionsModel(rapidViewId).andThen(function(versionsModel) {
            return _.map(versionsModel.getAllVersions(), function(version) {
                return {
                    id: version.id,
                    name: (version.project) ? version.project.key + ': ' + version.name : version.name
                };
            });
        });
    };

    /**
     * Convenience function to check if a versionId is present in a list of versions.
     *
     * @param {Object[]} versions
     * @param {number} versionId
     * @returns {boolean}
     */
    VersionsDataService.prototype.versionExists = function(versions, versionId) {
        return _.some(versions, function(version) {
            return version.id === versionId;
        });
    };

    return VersionsDataService;
});

AJS.namespace('GH.VersionsDataService', null, require('jira-agile/rapid/versions-data-service'));
AJS.namespace('GH.versionsDataService', null, new (require('jira-agile/rapid/versions-data-service'))());