AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common-base", "com.pyxis.greenhopper.jira:gh-rapid-config"], function () {
    var ConfigColumns = require('jira-agile/rapid/configuration/column-config');
    var $ = require('jquery');

    module("Ajax tests", {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
            ConfigColumns.model = {
                rapidViewId: 1
            };
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
        }
    });

    /* The purpose of these tests is to ensure the ajax calls are not broken while making a significant refactoring to how GH.Ajax works */
    test("reloadColumnsModel: Successful AJAX call renders column mappings", sinon.test(function () {

        this.stub(ConfigColumns, "renderColumnMapping");

        GH.Test.respondToGetWith200(this, "/rapidviewconfig/editmodel.json", {});

        ConfigColumns.reloadColumnsModel();

        this.server.respond();

        ok(ConfigColumns.renderColumnMapping.called, "Called success method");
    }));

    test("reloadColumnsModel: Failed AJAX call does not render columns (no error handling)", sinon.test(function () {
        this.stub(ConfigColumns, "renderColumnMapping");

        GH.Test.respondToGetWith500(this, "/rapidviewconfig/editmodel.json", {});

        ConfigColumns.reloadColumnsModel();

        this.server.respond();

        ok(!ConfigColumns.renderColumnMapping.called, "Nothing called when ajax fails");
    }));

    test("save: Successful AJAX call renders column mappings", sinon.test(function () {

        this.stub(ConfigColumns, "renderColumnMapping");

        GH.Test.respondToPutWith200(this, "/rapidviewconfig/columns", {});

        ConfigColumns.save();

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(ConfigColumns.renderColumnMapping.called, "Called success method");
    }));

    test("save: Failed AJAX call does not render columns (no error handling)", sinon.test(function () {
        this.stub(ConfigColumns, "renderColumnMapping");

        GH.Test.respondToPutWith500(this, "/rapidviewconfig/columns", {});

        ConfigColumns.save();

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(!ConfigColumns.renderColumnMapping.called, "Nothing called when ajax fails");
    }));

    module("Set resolution checkbox test", {
        setup: function setup() {
            ConfigColumns.model = {
                "canEdit": true,
                "currentStatisticsField": {
                    "isEnabled": false
                },
                "statisticsFields": [],
                "mappedColumns": [{
                    "id": 17,
                    "name": "In Progress",
                    "min": "",
                    "max": "",
                    "mappedStatuses": [{
                        "id": "3",
                        "name": "In Progress",
                        "iconUrl": "http://localhost:2990/jira/images/icons/statuses/inprogress.png",
                        "statusCategory": {
                            "id": "4",
                            "key": "indeterminate",
                            "colorName": "yellow"
                        },
                        "issueCount": 0,
                        "isPresentInWorkflow": true,
                        "isResolutionDone": false
                    }]
                }],
                "unmappedStatuses": [],
                "workflow": {
                    "isSimplifiedWorkflowFeatureEnabled": true,
                    "usingSimplifiedWorkflow": true,
                    "isProjectAdminOfSimplifiedWorkflow": true,
                    "simplifiedWorkflowProjectName": "Software",
                    "simplifiedWorkflowProjectKey": "SW"
                },
                "unmappedStatusesWithIssues": [],
                "unmappedStatusesWithoutIssues": []
            };
        }
    });

    function renderColumnMappingView(model) {
        return GH.tpl.columnconfig.renderColumnMappingView({
            'model': model,
            'lastUpdated': '1/1/1',
            'simplifiedWorkflowProjectName': "Software",
            'adminWorkflowUrl': 'www.admin.com/workflow',
            'contactAdminUrl': 'www.admin.com',
            'simplifiedWorkflowLearnMoreUrl': 'www.admin.com/learnmore',
            'shouldRenderKanbanBacklogColumn': true
        });
    }

    test("Set Resolution checkbox should be visible and enabled when user has admin permission over the workflow", sinon.test(function () {
        var model = ConfigColumns.model;
        model.workflow.isProjectAdminOfSimplifiedWorkflow = true;

        var $output = $('<div>').html(renderColumnMappingView(model));

        var $checkbox = $output.find('.ghx-status[data-statusid=3]').find('.ghx-done input');

        ok($checkbox.length > 0, "Expected resolution checkbox to be visible");
        ok($checkbox.is(':enabled'), "Expected resolution checkbox to be enabled");
    }));

    test("Set Resolution checkbox should be visible but disabled when user does not have admin permission over the workflow", sinon.test(function () {
        var model = ConfigColumns.model;
        model.workflow.isProjectAdminOfSimplifiedWorkflow = false;

        var $output = $('<div>').html(renderColumnMappingView(model));

        var $checkbox = $output.find('.ghx-status[data-statusid=3]').find('.ghx-done input');

        ok($checkbox.length > 0, "Expected resolution checkbox to be visible");
        ok($checkbox.is(':disabled'), "Expected resolution checkbox to be disabled");
    }));

    test("Set Resolution checkbox should be checked when the status is done resolution", sinon.test(function () {
        var model = ConfigColumns.model;
        model.mappedColumns[0].mappedStatuses[0].isResolutionDone = true;

        var $output = $('<div>').html(renderColumnMappingView(model));

        var $checkbox = $output.find('.ghx-status[data-statusid=3]').find('.ghx-done input');

        ok($checkbox.length > 0, "Expected resolution checkbox to be visible");
        ok($checkbox.is(':checked'), "Expected resolution checkbox to be checked");
    }));

    test("Set Resolution checkbox should not be visible when not using simplified workflow", sinon.test(function () {
        var model = ConfigColumns.model;
        model.workflow.usingSimplifiedWorkflow = false;

        var $output = $('<div>').html(renderColumnMappingView(model));

        var $checkbox = $output.find('.ghx-status[data-statusid=3]').find('.ghx-done input');

        ok($checkbox.length === 0, "Expected resolution checkbox to not be visible");
    }));
});