/**
 * Holds the code for the rapid view delete dialog
 */
define('jira-agile/rapid/configuration/delete-rapid-view-dialog',
    ["jira-agile/rapid/ajax", "jira/util/formatter", "jquery", "jira/util/strings"],
    function(Ajax, formatter, $, Strings) {
        const DeleteDialog = {};

        /**
         * Renders the create rapidview dialog given the create model
         */
        DeleteDialog.showDeleteDialog = function(rapidViewId, rapidViewName) {
            var dlg = GH.Dialog.create({
                width : 500,
                height : 350,
                id : 'ghx-rapidview-delete'
            });
            $('#'+dlg.id).addClass('ghx-dialog');
            dlg.addHeader(formatter.I18n.getText('gh.rapid.view.delete'));
            dlg.addPanel('', 'panel');
            dlg.getCurrentPanel().html(formatter.I18n.getText('gh.rapid.view.delete.confirm', Strings.escapeHtml(String(rapidViewName))));
            dlg.addButton(
                formatter.I18n.getText('gh.rapid.operations.delete'),
                function() {
                    dlg.disableControls();
                    dlg.dispose();
                    DeleteDialog.doDelete(rapidViewId, rapidViewName);
                },'aui-button'
            );
            GH.Dialog.addCancelButton(dlg);

            dlg.show();
            // focus on the first button in the button bar
            $('#'+dlg.id).find('.dialog-button-panel .button-panel-cancel-link').focus();
        };

        /**
         * Submits the dialog data
         */
        DeleteDialog.doDelete = function(rapidViewId, rapidViewName) {

            Ajax.del({
                url: '/rapidview/'+rapidViewId
            })
                .done(function(result) {
                    DeleteDialog.handleSuccess(rapidViewId, rapidViewName);
                });
        };

        DeleteDialog.handleSuccess = function(rapidViewId, rapidViewName) {
            $(GH).trigger('ghx.rapidview.deleted', {
                rapidViewId: rapidViewId,
                rapidViewName: rapidViewName,
                message: formatter.I18n.getText('gh.rapid.view.delete.success', Strings.escapeHtml(String(rapidViewName)))
            });
        };

        return DeleteDialog;
    });

AJS.namespace('GH.RapidBoard.DeleteDialog', null, require('jira-agile/rapid/configuration/delete-rapid-view-dialog'));
