AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function() {
    const DeleteDialog = require('jira-agile/rapid/configuration/delete-rapid-view-dialog');

    module("loadContent", {
        setup: function() {
            GH.Test.setUpFakeServer(this);
        },
        teardown: function() {
            GH.Test.restoreServer(this);
        }
    });

    test("release: Successful AJAX call calls success handler", sinon.test(function() {
        this.stub(DeleteDialog, "handleSuccess");

        GH.Test.respondToDeleteWith200(this, "/rapidview/", {});

        DeleteDialog.doDelete(6);

        this.server.respond();

        ok(DeleteDialog.handleSuccess.called, "Called success method");

    }));

    test("release: Failed AJAX call does nothing (no specific error handling)", sinon.test(function() {

        this.stub(DeleteDialog, "handleSuccess");

        GH.Test.respondToDeleteWith500(this, "/rapidview/", {});

        DeleteDialog.doDelete();

        this.server.respond();

        ok(!DeleteDialog.handleSuccess.called, "Did not call success method");
    }));
});