define('jira-agile/rapid/configuration/manage-views', ["jira-agile/gh-shortener", "jira-agile/rapid/user-data", "jira-agile/rapid/ajax", "jira-agile/rapid/ui/notification", "underscore", "jquery", "jira-agile/rapid/configuration/delete-rapid-view-dialog", "jira-agile/rapid/analytics-tracker"], function (Shortener, UserData, Ajax, Notification, _, $, DeleteDialog, AnalyticsTracker) {

    "use strict";

    var ManageViews = {};

    ManageViews.analytics = new AnalyticsTracker('gh.manageviews');

    ManageViews.init = function () {
        // create view dialog
        GH.Dialog.CreateView.init();

        // load the model
        ManageViews.loadModel();

        // assign delete RapidView button
        $(document).delegate('.ghx-delete-view', 'click', function (event) {
            event.preventDefault();
            var rapidViewId = $(this).attr('data-view-id');
            var rapidViewName = $(this).attr('data-view-name');
            DeleteDialog.showDeleteDialog(rapidViewId, rapidViewName);
        });

        // handle delete dialog success
        $(GH).bind('ghx.rapidview.deleted', function (event, data) {
            Notification.showSuccess(data.message);
            ManageViews.loadModel();
        });

        // assign copy RapidView button
        $(document).delegate('.js-copy-view', 'click', function (event) {
            event.preventDefault();
            var rapidViewId = $(this).attr('data-view-id');
            var rapidViewName = $(this).attr('data-view-name');
            GH.ViewActions.actionCopy(rapidViewId, rapidViewName);
        });

        new ManageViews.analytics.trigger("show");
    };

    /**
     * Calls the rapid board data rest service.
     */
    ManageViews.loadModel = function () {
        Ajax.get({
            url: '/rapidviews/viewsData.json'
        }, "manageViews").done(ManageViews.render);
    };

    /**
     * Renders the complete edit screen
     */
    ManageViews.render = function (model) {

        var canCopy = UserData.hasUser();

        GH.RapidViewConfig.storeGlobalConfig(model.globalConfig);

        // render the view actions
        GH.ViewActions.renderOnManage();

        // identify the page
        $('body').addClass('ghx-board-manage');

        // render the header html
        if (model.views.length > 0) {
            // collect the board admins and display them as shortened
            ManageViews.shortenBoardAdmins(model.views);

            model.views.sort(GH.RapidBoard.viewModelComparator);
            $('#ghx-content-main').html(GH.tpl.rapid.manageviews.renderViewsTable({ views: model.views, canCopy: canCopy }));
        } else {
            $('#ghx-content-main').html(GH.tpl.board.x.renderNoViews());
        }

        // touch detection
        if ($.support.touch) {
            $('#gh').removeClass('ghx-no-touch').addClass('ghx-touch');
        }

        _.each(model.views, function (view) {
            view.shortener = new Shortener({
                items: "span.ghx-board-admin-list-item",
                element: "div.board-admins-list-" + view.id,
                numRows: 1
            });
        });
    };

    ManageViews.shortenBoardAdmins = function (views) {
        _.each(views, function (view) {
            if (view.boardAdmins) {
                view.renderableBoardAdmins = GH.RapidBoard.BoardAdminsPicker.getOrderedUnion(view.boardAdmins);
            } else {
                view.renderableBoardAdmins = [];
            }
        });
    };

    return ManageViews;
});

AJS.namespace('GH.RapidBoard.ManageViews', null, require('jira-agile/rapid/configuration/manage-views'));