/**
 * Defines functions called by the keyboard-shortcut modules.
 * This file defines implementations for keyboard shortcuts when on the Rapid Board.
 * For each function that is defined here, you must also define one in gh-keyboardshortcuts.js.
 */
GH.Shortcut = {
    // "globally applicable links"
    focusBoardSearch: function() {

    },
    newIssue: function() {
        AJS.$('#create_link').click();
    },
    toggleBox: function() {

    },
    editIssuePriority: function() {

    },
    projector: function() {
        GH.PresentationMode.iterateThroughPresentationModes(GH.PresentationMode.allModes);
    },

    // Issue specific operations
    viewIssue: function() {
        GH.IssueOperationShortcuts.viewSelectedIssue();
    },
    editIssue: function() {
        GH.IssueOperationShortcuts.editSelectedIssue();
    },
    assignIssue: function() {
        GH.IssueOperationShortcuts.assignSelectedIssue();
    },
    assignIssueToMe: function() {
        GH.IssueOperationShortcuts.assignSelectedIssueToMe();
    },
    commentIssue: function() {
        GH.IssueOperationShortcuts.commentSelectedIssue();
    },
    editIssueLabels: function() {
        GH.IssueOperationShortcuts.editSelectedIssueLabels();
    },
    showOperationsDialog: function() {
        GH.IssueOperationShortcuts.showOperationsDialog();
    },
    sendToTop: function(source) {
        if(GH.WorkController.isActive()) {
            GH.WorkKBShortcuts.sendToTop(source);
        }
        else if (GH.PlanController.isActive()) {
            GH.PlanKBShortcuts.sendToTop(source);
        }
    },
    sendToBottom: function(source) {
        if(GH.WorkController.isActive()) {
            GH.WorkKBShortcuts.sendToBottom(source);
        }
        else if (GH.PlanController.isActive()) {
            GH.PlanKBShortcuts.sendToBottom(source);
        }
    },

    // Navigation
    nextIssue: function() {
        if(GH.WorkController.isActive()) {
            GH.WorkKBNavigation.selectNextIssue();
        }
        else if (GH.PlanController.isActive()) {
            GH.BacklogSelectionController.selectNextIssue();
        }
    },
    previousIssue: function() {
        if(GH.WorkController.isActive()) {
            GH.WorkKBNavigation.selectPreviousIssue();
        }
        else if (GH.PlanController.isActive()) {
            GH.BacklogSelectionController.selectPreviousIssue();
        }
    },
    nextBox: function() {
        if(GH.WorkController.isActive()) {
            GH.WorkKBNavigation.selectNextColumn();
        }
    },
    previousBox: function() {
        if(GH.WorkController.isActive()) {
            GH.WorkKBNavigation.selectPreviousColumn();
        }
    },
    toggleSwimlanes: function() {
        if(GH.WorkController.isActive()) {
            GH.WorkKBNavigation.toggleSwimlanes();
        }
    },
    planMode: function() {
        if (GH.RapidBoard.State.isPlanModeAvailable()) {
            GH.RapidBoard.ViewController.setMode('plan');
        } else {
            this.workMode();
        }
    },
    workMode: function() {
        GH.RapidBoard.ViewController.setMode('work');
    },
    reportMode: function() {
        GH.RapidBoard.ViewController.setMode('report');
    },

    // Work specific shortcuts
    toggleIssue: function() {
        if(GH.WorkController.isActive()) {
            GH.WorkController.toggleDetailsView();
        } else if (GH.PlanController.isActive()) {
            GH.PlanController.toggleDetailsView();
        }
    }
};

/**
 * Handles Ctrl+F, firing a event for analytics
 */
AJS.$(document).bind('keydown');
