(function($, _, Events) {
    function PageableCollection(items, options) {
        options = options || {};
        this.collection = items;
        this.pageSize = options.pageSize || 25;
        this.state = {
            currentPage: 1,
            firstPage: 1,
            lastPage: 0
        };
    }

    PageableCollection.prototype = new Events();

    _.extend(PageableCollection.prototype, {
        setCollection: function setCollection(collection) {
            this.collection = collection;
            this.state.collectionLength = this.collection.length;
            this.state.lastPage = Math.ceil(this.state.collectionLength / this.pageSize);
            this.state.currentPage = 1;
        },
        getPaginated: function getPaginated() {
            var startIdx = (this.state.currentPage - 1) * this.pageSize;
            var endIdx = startIdx + this.pageSize;
            return this.collection.slice(startIdx, endIdx);
        },
        setPage: function setPage(page) {
            page = parseInt(page, 10);
            if (!isNaN(page)) {
                this.state.currentPage = Math.max(Math.min(page, this.state.lastPage), this.state.firstPage);
                this.trigger('page-change', this.currentPage);
            }
        },
        previousPage: function previousPage() {
            if (this.currentPage > 1) {
                this.setPage(this.state.currentPage - 1);
            }
        },
        nextPage: function nextPage() {
            var maxPage = Math.floor(this.state.collectionLength / this.pageSize);
            if (this.currentPage < maxPage) {
                this.setPage(this.state.currentPage + 1);
            }
        }
    });

    GH.Pagination = GH.Pagination || {};
    GH.Pagination.PageableCollection = PageableCollection;

}(AJS.$, _, GH.Events));