AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function () {
    var RapidBoardState = require('jira-agile/rapid/state/rapid-board-state');
    module("RapidBoardState:isScrumBoard", {
        setup: function setup() {
            GH.RapidViewConfig.currentData.data = {
                sprintSupportEnabled: true
            };
        }
    });

    test("Should return true when mode is Scrum", sinon.test(function () {
        ok(RapidBoardState.isScrumBoard());
    }));

    test("Should return true when mode is not Scrum", sinon.test(function () {
        GH.RapidViewConfig.currentData.data = {
            sprintSupportEnabled: false
        };
        ok(RapidBoardState.isKanbanBoard());
    }));

    module("RapidBoardState:isPlanModeAvailable", {
        setup: function setup() {
            GH.UserData.userConfig = {};
            GH.UserData.userConfig.isGlobalAdmin = false;
        }
    });

    test("isPlanModeAvailable() should return true for Scrum board", sinon.test(function () {
        GH.RapidViewConfig.currentData.data = {
            sprintSupportEnabled: true
        };

        equal(RapidBoardState.isPlanModeAvailable(), true, "should return true");
    }));

    test("isPlanModeAvailable() should return true for Kanban board when KanPlan lab is enabled and board is configured", sinon.test(function () {
        GH.RapidViewConfig.currentData.data = {
            sprintSupportEnabled: false
        };

        GH.RapidBoard.kanPlanLabEnabled = true;
        GH.RapidViewConfig.kanPlanEnabled = true;

        equal(RapidBoardState.isPlanModeAvailable(), true, "should return true");
    }));

    test("isPlanModeAvailable() should return false when KanPlan lab is disabled", sinon.test(function () {
        GH.RapidViewConfig.currentData.data = {
            sprintSupportEnabled: false
        };

        GH.RapidBoard.kanPlanLabEnabled = false;
        GH.RapidViewConfig.kanPlanEnabled = true;

        equal(RapidBoardState.isPlanModeAvailable(), false, "should return false");
    }));

    test("isPlanModeAvailable() should return false when board is NOT configured", sinon.test(function () {
        GH.RapidViewConfig.currentData.data = {
            sprintSupportEnabled: false
        };

        GH.RapidBoard.kanPlanLabEnabled = true;
        GH.RapidViewConfig.kanPlanEnabled = false;

        equal(RapidBoardState.isPlanModeAvailable(), false, "should return false");
    }));

    module("RapidBoardState:isLoadingKanPlanWhileItDisabled", {
        setup: function setup() {
            GH.UserData.userConfig = {};
            GH.UserData.userConfig.isGlobalAdmin = false;
            GH.RapidViewConfig.currentData.data = {
                sprintSupportEnabled: false
            };
            this.getCurrentUrlStateStub = sinon.stub(GH.RapidBoard.UrlState, "getCurrentUrlState", function () {
                return "view=" + this.mode;
            }.bind(this));

            this.normalizeStringParamStub = sinon.stub(GH.RapidBoard.UrlState, "normalizeStringParam", function () {
                return this.mode;
            }.bind(this));

            this.isPlanModeAvailableStub = sinon.stub(RapidBoardState, "isPlanModeAvailable", function () {
                return this.isPlanModeAvailable;
            }.bind(this));
        },
        teardown: function teardown() {
            this.getCurrentUrlStateStub.restore();
            this.normalizeStringParamStub.restore();
            this.isPlanModeAvailableStub.restore();
        }
    });

    test("should NOT load the KanPlan when it's disabled and the mode is plan", sinon.test(function () {
        this.mode = "planning";
        this.isPlanModeAvailable = false;
        equal(RapidBoardState.isLoadingKanPlanWhileItDisabled(), true, "should return true");
    }));

    test("should load the KanPlan when it's enabled and the mode is plan", sinon.test(function () {
        this.mode = "planning";
        this.isPlanModeAvailable = true;
        equal(RapidBoardState.isLoadingKanPlanWhileItDisabled(), false, "should return false");
    }));

    test("should return false when the mode is detail", sinon.test(function () {
        this.mode = "detail";
        this.isPlanModeAvailable = true;
        equal(RapidBoardState.isLoadingKanPlanWhileItDisabled(), false, "should return false");
    }));

    test("should return false when the mode is planning with no detail", sinon.test(function () {
        this.mode = "planning.nodetail";
        this.isPlanModeAvailable = true;
        equal(RapidBoardState.isLoadingKanPlanWhileItDisabled(), false, "should return false");
    }));

    module("RapidBoardState:initializeState", {
        setup: function setup() {
            this.getStoredModeStub = sinon.stub(RapidBoardState, "getStoredMode", function () {
                return this.mode;
            }.bind(this));

            this.isPlanModeAvailableStub = sinon.stub(RapidBoardState, "isPlanModeAvailable", function () {
                return this.isPlanModeAvailable;
            }.bind(this));

            this.isLoadingKanPlanWhileItDisabledStub = sinon.stub(RapidBoardState, "isLoadingKanPlanWhileItDisabled", function () {
                return this.loadingKanPlanWhileItDisabled;
            }.bind(this));
            this.replaceStateStub = sinon.stub(GH.RapidBoard.UrlState, "replaceState");
            this.loadStateStub = sinon.stub(GH.RapidBoard.UrlState, "loadState");
        },
        teardown: function teardown() {
            this.getStoredModeStub.restore();
            this.isPlanModeAvailableStub.restore();
            this.isLoadingKanPlanWhileItDisabledStub.restore();
            this.replaceStateStub.restore();
            this.loadStateStub.restore();
        }
    });

    test("the mode should be replace to work when loading KanPlan while it's disabled", sinon.test(function () {
        this.mode = "plan";
        this.isPlanModeAvailable = false;

        this.stub(RapidBoardState, "setMode");

        RapidBoardState.initializeState();

        equal(RapidBoardState.setMode.calledWith("work"), true, "should set mode to work");
    }));

    test("the mode should NOT be replace to work when KanPlan it enabled", sinon.test(function () {
        this.mode = "plan";
        this.isPlanModeAvailable = true;

        this.stub(RapidBoardState, "setMode");

        RapidBoardState.initializeState();

        equal(RapidBoardState.setMode.calledWith("plan"), true, "should set mode to plan");
    }));

    test("the mode should set into work when loading Kanban", sinon.test(function () {
        this.mode = "work";
        this.isPlanModeAvailable = true;

        this.stub(RapidBoardState, "setMode");

        RapidBoardState.initializeState();

        equal(RapidBoardState.setMode.calledWith("work"), true, "should set mode to work");
    }));

    test("the url should be replace when loading KanPlan while it's disabled", sinon.test(function () {
        this.loadingKanPlanWhileItDisabled = true;

        RapidBoardState.initializeState();

        equal(GH.RapidBoard.UrlState.replaceState.calledWith(true), true, "should force to replace state");
    }));

    test("the url should NOT be replace in other cases", sinon.test(function () {
        this.loadingKanPlanWhileItDisabled = false;

        RapidBoardState.initializeState();

        equal(GH.RapidBoard.UrlState.replaceState.calledWith(true), false, "should NOT force to replace state");
    }));
});