/* global GH */
/**
 * Burndown Report Chart Controller
 * @module jira-agile/rapid/ui/chart/burndown-report-chart-controller
 * @requires module:jira-agile/rapid/ui/chart/burndown-chart-model
 * @requires module:jira-agile/rapid/ui/chart/burndown-chart-view
 * @requires module:jira-agile/rapid/ui/chart/chart-view
 */
define('jira-agile/rapid/ui/chart/burndown-report-chart-controller', ['require'], function(require) {
    'use strict';

    // REQUIRES
    var BurndownChartModel = require('jira-agile/rapid/ui/chart/burndown-chart-model');
    var BurndownChartView = require('jira-agile/rapid/ui/chart/burndown-chart-view');
    var ChartView = require('jira-agile/rapid/ui/chart/chart-view');

    // GLOBALS... FIX ME
    var Ajax = GH.Ajax;

    /**
     * Chart view component.
     *
     * Loads chart data, then passes contorl to chart implementation for actual rendering
     */
    var BurndownReportChartController = {};

    BurndownReportChartController.displayed = false;

    BurndownReportChartController.rapidViewId = undefined;
    BurndownReportChartController.sprintId = undefined;
    BurndownReportChartController.estimationStatisticId = undefined;
    BurndownReportChartController.nonWorkingDaysShown = undefined;

    BurndownReportChartController.setRapidView = function (rapidViewId) {
        BurndownReportChartController.rapidViewId = rapidViewId;
    };

    BurndownReportChartController.setSprintId = function (sprintId) {
        BurndownReportChartController.sprintId = sprintId;
    };

    BurndownReportChartController.setEstimationStatistic = function (estimationStatistic) {
        BurndownReportChartController.estimationStatisticId = estimationStatistic;
    };

    BurndownReportChartController.show = function () {
        BurndownReportChartController.displayed = true;
    };

    BurndownReportChartController.hide = function () {
        BurndownReportChartController.displayed = false;
    };

    BurndownReportChartController.setNonWorkingDaysShown = function (nonWorkingDaysShown) {
        BurndownReportChartController.nonWorkingDaysShown = nonWorkingDaysShown;
    };

    /**
     * Loads the chart.
     * This function updates the tools, initializes the spinner, then sends off a request to load the data
     */
    BurndownReportChartController.loadChartData = function () {
        if (!BurndownReportChartController.sprintId) {
            return;
        }

        // Put together the ajax request, including the configuration from the filters
        var data = {
            'rapidViewId': BurndownReportChartController.rapidViewId,
            'sprintId': BurndownReportChartController.sprintId,
            'statisticFieldId': BurndownReportChartController.estimationStatisticId
        };

        // then issue the request
        return Ajax.get({
            url: '/rapid/charts/scopechangeburndownchart.json',
            data: data
        }, 'rapidChartData')
            .done(BurndownReportChartController.processChartData)
            .fail(ChartView.hideSpinner);
    };

    /**
     * Processes the returned chart data.
     */
    BurndownReportChartController.processChartData = function (data) {
        // ignore if we are not displayed anymore
        if (!BurndownReportChartController.displayed) {
            return;
        }

        // set the model
        BurndownChartModel.setRawData(data);

        BurndownChartView.setNonWorkingDaysShown(BurndownReportChartController.nonWorkingDaysShown);

        // show the chart
        BurndownChartView.showChart();
    };

    return BurndownReportChartController;
});
