AJS.test.require('com.pyxis.greenhopper.jira:gh-rapid', function() {
    var BurndownRate = require('jira-agile/rapid/ui/chart/burndown-rate');
    var ChartController = require('jira-agile/rapid/ui/chart/chart-controller');

    var startDate = new Date(2012, 10, 28).valueOf(); // Wednesday
    var endDate = new Date(2012, 11, 12).valueOf(); // Wednesday 2 weeks later
    var startWeekend1 = new Date(2012, 11, 1).valueOf();
    var endWeekend1 = new Date(2012, 11, 3).valueOf();
    var startWeekend2 = new Date(2012, 11, 8).valueOf();
    var endWeekend2 = new Date(2012, 11, 10).valueOf();

    var workRateData = {
        timezone: 'Australia/Sydney',
        rates: [
            { start: startDate, end: startWeekend1, rate: 1.0 },
            { start: startWeekend1, end: endWeekend1, rate: 0.0 },
            { start: endWeekend1, end: startWeekend2, rate: 1.0 },
            { start: startWeekend2, end: endWeekend2, rate: 0.0 },
            { start: endWeekend2, end: endDate, rate: 1.0 }
        ]
    };

    test('module "jira-agile/rapid/ui/chart/chart-controller" exists', function() {
        ok(ChartController);
        ok(GH.ChartController);
    });

    test('Calculation of non-working days', function() {
        BurndownRate.setRateData(workRateData);
        var nonWorkingBlocks = ChartController.getNonWorkingBlocks();

        // we just two weekends in the stubbed data
        equal(nonWorkingBlocks.length, 2);
        equal(nonWorkingBlocks[0].xaxis.from, startWeekend1);
        equal(nonWorkingBlocks[0].xaxis.to, endWeekend1);

        // Make sure we gave it a color
        ok(nonWorkingBlocks[0].color);
    });
});