/* global AJS, GH */
AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function () {
    var _ = require('underscore');
    var BurndownChartController = require('jira-agile/rapid/ui/chart/burndown-chart-controller');
    var ControlChartController = require('jira-agile/rapid/ui/chart/v2/controlchart/control-chart-controller');
    var CFDController = require('jira-agile/rapid/ui/chart/cfd-controller');
    var GlobalEvents = require('jira-agile/rapid/global-events');
    var VersionReportController = require('jira-agile/rapid/ui/chart/version-report-controller');

    GlobalEvents.trigger('pre-initialization');

    module("get normalized from internal state", {
        setup: function setup() {
            GH.ReportController.initCharts();
        }
    });

    test("Gets correct params for Cumulative Flow Diagram", sinon.test(function () {
        this.stub(GH.RapidBoard.State, "getBoardSettings").returns({
            chartType: CFDController.id
        });

        var normalized = {};
        GH.ReportUrlState.getNormalizedFromInternal(normalized);

        equal(normalized.chart, CFDController.id);
        equal(normalized.days, 7, "Sets default of 7 days");
        equal(normalized.from, 0, "Sets from to 0 by default");
        equal(normalized.to, 0, "Sets from to 0 by default");
        deepEqual(normalized.swimlane, [], "No swimlanes by default");
        deepEqual(normalized.quickFilter, [], "No quickfilter by default");
        deepEqual(normalized.column, [], "No columns by default");
        equal(_.toArray(normalized).length, 7, "Correct number of properties set");
    }));

    test("Gets correct params for Epic Report", sinon.test(function () {
        this.stub(GH.RapidBoard.State, "getBoardSettings").returns({
            chartType: GH.EpicReportController.id
        });
        this.stub(GH.EpicReportController, "getSelectedEpicKey").returns(1);

        var normalized = {};
        GH.ReportUrlState.getNormalizedFromInternal(normalized);

        equal(normalized.chart, GH.EpicReportController.id);
        equal(normalized.epic, 1, "Sets selected epic key");
        equal(_.toArray(normalized).length, 2, "Correct number of properties set");
    }));

    test("Gets correct params for Control Chart", sinon.test(function () {
        this.stub(GH.RapidBoard.State, "getBoardSettings").returns({
            chartType: ControlChartController.id
        });

        var normalized = {};
        GH.ReportUrlState.getNormalizedFromInternal(normalized);

        equal(normalized.chart, ControlChartController.id);
        equal(_.toArray(normalized).length, 1, "Correct number of properties set");
    }));

    test("Gets correct params for Burndown Chart", sinon.test(function () {
        this.stub(GH.RapidBoard.State, "getBoardSettings").returns({
            chartType: BurndownChartController.id
        });
        this.stub(BurndownChartController, "getSprintIdForUrl").returns(3);
        this.stub(BurndownChartController, "getEstimateIdForUrl").returns("issueType_");

        var normalized = {};
        GH.ReportUrlState.getNormalizedFromInternal(normalized);

        equal(normalized.chart, BurndownChartController.id);
        equal(normalized.sprint, 3);
        equal(normalized.estimate, "issueType_");
        equal(_.toArray(normalized).length, 3, "Correct number of properties set");
    }));

    test("Gets correct params for Sprint Retrospective Chart", sinon.test(function () {
        this.stub(GH.RapidBoard.State, "getBoardSettings").returns({
            chartType: GH.SprintRetrospectiveController.id
        });
        this.stub(GH.SprintRetrospectiveController, "getSelectedSprintId").returns(4);

        var normalized = {};
        GH.ReportUrlState.getNormalizedFromInternal(normalized);

        equal(normalized.chart, GH.SprintRetrospectiveController.id);
        equal(normalized.sprint, 4);
        equal(_.toArray(normalized).length, 2, "Correct number of properties set");
    }));

    test("Gets correct params for Version Report", sinon.test(function () {
        this.stub(GH.RapidBoard.State, "getBoardSettings").returns({
            chartType: VersionReportController.id
        });

        this.stub(VersionReportController, "getSelectedVersionId").returns(5);

        var normalized = {};
        GH.ReportUrlState.getNormalizedFromInternal(normalized);

        equal(normalized.chart, VersionReportController.id);
        equal(normalized.version, 5);
        equal(_.toArray(normalized).length, 2, "Correct number of properties set");
    }));

    test("Gets correct params for Velocity chart", sinon.test(function () {
        this.stub(GH.RapidBoard.State, "getBoardSettings").returns({
            chartType: GH.VelocityChartController.id
        });

        var normalized = {};
        GH.ReportUrlState.getNormalizedFromInternal(normalized);

        equal(normalized.chart, GH.VelocityChartController.id);
        equal(_.toArray(normalized).length, 1, "Correct number of properties set");
    }));

    test("Turns normalized state into correct URL params for Cumulative Flow diagram", sinon.test(function () {

        var normalized = {
            chart: CFDController.id,
            swimlane: [5],
            column: [6],
            quickFilter: [7],
            days: 8
        };
        var urlParams = {};
        GH.ReportController.initCharts();
        GH.ReportUrlState.toUrl(normalized, urlParams);

        equal(urlParams.chart, CFDController.id);
        deepEqual(urlParams.swimlane, [5]);
        deepEqual(urlParams.column, [6]);
        deepEqual(urlParams.quickFilter, [7]);
        equal(urlParams.days, 8);
        equal(_.toArray(urlParams).length, 5, "Correct number of properties set");
    }));

    test("Turns normalized state into correct URL params for Epic Report", sinon.test(function () {

        var normalized = {
            chart: GH.EpicReportController.id,
            epic: 3
        };
        var urlParams = {};
        GH.ReportController.initCharts();
        GH.ReportUrlState.toUrl(normalized, urlParams);

        equal(urlParams.chart, GH.EpicReportController.id);
        equal(urlParams.epic, 3);
        equal(_.toArray(urlParams).length, 2, "Correct number of properties set");
    }));

    test("Turns normalized state into correct URL params for Control Chart", sinon.test(function () {

        var normalized = {
            chart: ControlChartController.id,
            includeNonWorkingDays: true,
            columnIds: [1],
            quickFilterIds: [2],
            swimlaneIds: [3],
            days: 7
        };
        var urlParams = {};
        GH.ReportController.initCharts();
        GH.ReportUrlState.toUrl(normalized, urlParams);

        equal(urlParams.chart, ControlChartController.id);
        equal(urlParams.nwd, true);
        deepEqual(urlParams.column, [1]);
        deepEqual(urlParams.quickfilter, [2]);
        deepEqual(urlParams.swimlane, [3]);
        equal(urlParams.days, 7);
        equal(urlParams.from, undefined);
        equal(urlParams.to, undefined);
        equal(_.toArray(urlParams).length, 8, "Correct number of properties set");
    }));

    test("Turns normalized state into correct URL params for Burndown Chart", sinon.test(function () {

        var normalized = {
            chart: BurndownChartController.id,
            sprint: 5,
            estimate: "customfield_5"
        };
        var urlParams = {};
        GH.ReportController.initCharts();
        GH.ReportUrlState.toUrl(normalized, urlParams);

        equal(urlParams.chart, BurndownChartController.id);
        equal(urlParams.sprint, 5);
        equal(urlParams.estimate, "customfield_5");
        equal(_.toArray(urlParams).length, 3, "Correct number of properties set");
    }));

    test("Turns normalized state into correct URL params for Sprint Retrospective Chart", sinon.test(function () {

        var normalized = {
            chart: GH.SprintRetrospectiveController.id,
            sprint: 7
        };
        var urlParams = {};
        GH.ReportController.initCharts();
        GH.ReportUrlState.toUrl(normalized, urlParams);

        equal(urlParams.chart, GH.SprintRetrospectiveController.id);
        equal(urlParams.sprint, 7);
        equal(_.toArray(urlParams).length, 2, "Correct number of properties set");
    }));

    test("Turns normalized state into correct URL params for Version Report", sinon.test(function () {

        var normalized = {
            chart: VersionReportController.id,
            version: 100
        };
        var urlParams = {};
        GH.ReportController.initCharts();
        GH.ReportUrlState.toUrl(normalized, urlParams);

        equal(urlParams.chart, VersionReportController.id);
        equal(urlParams.version, 100);
        equal(_.toArray(urlParams).length, 2, "Correct number of properties set");
    }));

    test("Turns normalized state into correct URL params for Velocity Chart", sinon.test(function () {

        var normalized = { chart: GH.VelocityChartController.id };
        var urlParams = {};
        GH.ReportController.initCharts();
        GH.ReportUrlState.toUrl(normalized, urlParams);

        equal(urlParams.chart, GH.VelocityChartController.id);
        equal(_.toArray(urlParams).length, 1, "Correct number of properties set");
    }));

    test("Updates internal state for Cumulative flow diagram", sinon.test(function () {
        this.stub(GH.RapidBoard.State, "setChartType");

        var normalized = { chart: CFDController.id };
        GH.ReportUrlState.updateInternalFromNormalized(normalized);

        ok(GH.RapidBoard.State.setChartType.calledWith(CFDController.id));
    }));

    test("Updates internal state for Epic Report", sinon.test(function () {
        this.stub(GH.RapidBoard.State, "setChartType");
        this.stub(GH.EpicReportController, "setSelectedEpicFromUrlState");

        var normalized = { chart: GH.EpicReportController.id };
        GH.ReportUrlState.updateInternalFromNormalized(normalized);

        ok(GH.RapidBoard.State.setChartType.calledWith(GH.EpicReportController.id));
        ok(GH.EpicReportController.setSelectedEpicFromUrlState.called);
    }));

    test("Updates internal state for Control Chart", sinon.test(function () {
        this.stub(GH.RapidBoard.State, "setChartType");

        var normalized = { chart: ControlChartController.id };
        GH.ReportUrlState.updateInternalFromNormalized(normalized);

        ok(GH.RapidBoard.State.setChartType.calledWith(ControlChartController.id));
    }));

    test("Updates internal state for Burndown Chart", sinon.test(function () {
        this.stub(GH.RapidBoard.State, "setChartType");
        this.stub(BurndownChartController, "setSelectedSprintFromUrlState");

        var normalized = { chart: BurndownChartController.id };
        GH.ReportUrlState.updateInternalFromNormalized(normalized);

        ok(GH.RapidBoard.State.setChartType.calledWith(BurndownChartController.id));
        ok(BurndownChartController.setSelectedSprintFromUrlState.called);
    }));

    test("Updates internal state for Sprint Retrospective Chart", sinon.test(function () {
        this.stub(GH.RapidBoard.State, "setChartType");
        this.stub(GH.SprintRetrospectiveController, "setSelectedSprintFromUrlState");

        var normalized = { chart: GH.SprintRetrospectiveController.id };
        GH.ReportUrlState.updateInternalFromNormalized(normalized);

        ok(GH.RapidBoard.State.setChartType.calledWith(GH.SprintRetrospectiveController.id));
        ok(GH.SprintRetrospectiveController.setSelectedSprintFromUrlState.called);
    }));

    test("Updates internal state for Version Report", sinon.test(function () {
        this.stub(GH.RapidBoard.State, "setChartType");
        this.stub(VersionReportController, "setSelectedVersionFromState");

        var normalized = { chart: VersionReportController.id };
        GH.ReportUrlState.updateInternalFromNormalized(normalized);

        ok(GH.RapidBoard.State.setChartType.calledWith(VersionReportController.id));
        ok(VersionReportController.setSelectedVersionFromState.called);
    }));

    test("Updates internal state for Velocity Chart", sinon.test(function () {
        this.stub(GH.RapidBoard.State, "setChartType");

        var normalized = { chart: GH.VelocityChartController.id };
        GH.ReportUrlState.updateInternalFromNormalized(normalized);

        ok(GH.RapidBoard.State.setChartType.calledWith(GH.VelocityChartController.id));
    }));

    test("Get normalized from URL for Cumulative Flow Diagram", sinon.test(function () {
        var urlParams = {
            chart: CFDController.id,
            days: 7,
            swimlane: [2, 3],
            column: [1],
            quickFilter: [4]
        };
        var normalized = {};

        GH.ReportUrlState.getNormalizedFromUrl(urlParams, normalized);

        equal(normalized.chart, CFDController.id);
        equal(normalized.days, 7);
        equal(normalized.from, 0);
        equal(normalized.to, 0);
        deepEqual(normalized.swimlane, [2, 3]);
        deepEqual(normalized.column, [1]);
        deepEqual(normalized.quickFilter, [4]);
        deepEqual(_.toArray(normalized).length, 7, "Correct number of properties set");
    }));

    test("Get normalized from URL for Epic Report", sinon.test(function () {
        var urlParams = { chart: GH.EpicReportController.id, epic: "1001" };
        var normalized = {};

        GH.ReportUrlState.getNormalizedFromUrl(urlParams, normalized);

        equal(normalized.chart, GH.EpicReportController.id);
        equal(normalized.epic, "1001");
        equal(_.toArray(normalized).length, 2, "Correct number of properties set");
    }));

    test("Get normalized from URL for Control Chart", sinon.test(function () {
        var urlParams = {
            chart: ControlChartController.id,
            nwd: 'true',
            days: 7,
            swimlane: [2, 3],
            column: [1],
            quickfilter: [4]
        };
        var normalized = {};

        GH.ReportUrlState.getNormalizedFromUrl(urlParams, normalized);

        equal(normalized.chart, ControlChartController.id);
        equal(normalized.includeNonWorkingDays, true);
        equal(normalized.days, 7);
        deepEqual(normalized.swimlaneIds, [2, 3]);
        deepEqual(normalized.columnIds, [1]);
        deepEqual(normalized.quickFilterIds, [4]);
        equal(normalized.from, undefined);
        equal(normalized.to, undefined);
        deepEqual(_.toArray(normalized).length, 6, "Correct number of properties set");
    }));

    test("Get normalized from URL for Burndown Chart", sinon.test(function () {
        var urlParams = {
            chart: BurndownChartController.id,
            sprint: 10,
            estimate: "customfield_1"
        };
        var normalized = {};

        GH.ReportUrlState.getNormalizedFromUrl(urlParams, normalized);

        equal(normalized.chart, BurndownChartController.id);
        equal(normalized.sprint, 10);
        equal(normalized.estimate, "customfield_1");
        equal(_.toArray(normalized).length, 3, "Correct number of properties set");
    }));

    test("Get normalized from URL for Sprint Retrospective Chart", sinon.test(function () {
        var urlParams = {
            chart: GH.SprintRetrospectiveController.id,
            sprint: 20
        };
        var normalized = {};

        GH.ReportUrlState.getNormalizedFromUrl(urlParams, normalized);

        equal(normalized.chart, GH.SprintRetrospectiveController.id);
        equal(normalized.sprint, 20);
        equal(_.toArray(normalized).length, 2, "Correct number of properties set");
    }));

    test("Get normalized from URL for Version Report", sinon.test(function () {
        var urlParams = {
            chart: VersionReportController.id,
            version: 15
        };
        var normalized = {};

        GH.ReportUrlState.getNormalizedFromUrl(urlParams, normalized);

        equal(normalized.chart, VersionReportController.id);
        equal(normalized.version, 15);
        equal(_.toArray(normalized).length, 2, "Correct number of properties set");
    }));

    test("Get normalized from URL for Velocity Chart", sinon.test(function () {
        var urlParams = { chart: GH.VelocityChartController.id };
        var normalized = {};

        GH.ReportUrlState.getNormalizedFromUrl(urlParams, normalized);

        equal(normalized.chart, GH.VelocityChartController.id);
        equal(_.toArray(normalized).length, 1, "Correct number of properties set");
    }));
});