/* globals AJS, GH, _ */
GH.SprintRetrospectiveView = {};

GH.SprintRetrospectiveView.createRetroDialog = null;
GH.SprintRetrospectiveView.retroApplinkData = null;

GH.SprintRetrospectiveView.showSprintReport = function (sprint, sprintData, estimationStatistic, sprintJql, completedIssuesJql, incompletedIssuesJql, issuescompletedInAnotherSprintJql, puntedIssuesJql) {

    var FeatureFlagManager = require('jira/featureflags/feature-manager');

    var showPages = true; // todo: replace with value from model
    var canEdit = true; // todo: replace with value from model
    var showGoal = FeatureFlagManager.isFeatureEnabled("com.atlassian.jira.agile.darkfeature.sprint.goal");

    AJS.$('#ghx-report-content .ghx-sprint-report')
        .empty()
        .append(GH.tpl.sprintretrospective.renderSprintReport({
            sprint:sprintData,
            estimationStatistic:estimationStatistic,
            completedIssuesJql:completedIssuesJql,
            incompletedIssuesJql:incompletedIssuesJql,
            puntedIssuesJql:puntedIssuesJql,
            issuescompletedInAnotherSprintJql: issuescompletedInAnotherSprintJql,
            hasIssuesAddedAfterSprintStart:_.keys(sprintData.contents.issueKeysAddedDuringSprint).length
        }))
        .show();

    AJS.$('#ghx-sprint-report-meta')
        .empty()
        .append(GH.tpl.sprintretrospective.renderSprintReportHeader({
            sprint:sprintData.sprint,
            showPages: showPages,
            linkedPagesCount: sprintData.sprint.remoteLinks.length,
            endedByHtml: sprintData.lastUserToClose,
            showGoal: showGoal
        }))
        .show();
    AJS.$('#ghx-sprint-report-meta').find('.ghx-sprint-goal').tooltip({className: 'ghx-sprint-report-goal-tooltip'});

    GH.LinkedPagesController.initDialogTrigger(
        GH.LinkedPagesController.SPRINT, GH.LinkedPagesController.REPORT, sprintData.sprint.id,
        AJS.$('#ghx-sprint-report-meta .js-view-entity-pages')
    );

    AJS.$('#ghx-report-controls').empty();

    GH.ReportController.renderActions(
        AJS.$('#ghx-chart-actions'),
        GH.SprintRetrospectiveController.sprintPicker.getItems(),
        sprintData.sprint,
        sprintJql
    );
};

/**
 * End date (tick 1) will need extra room if any of the ticks are too close.
 * Ticks are too close if middle one is < 10% of range from either end.
 * @param ticks either 2 or 3 x-axis values. Expected to be in order.
 * @param now timestamp for now (or at least, when the data was generated)
 */
GH.SprintRetrospectiveView.doesEndDateNeedExtraRoom = function (ticks, now) {
    var delta;
    if (ticks.length === 3) {
        // if we have three ticks, we want to check if tick 1 is either 10% from tick 0 or tick 2
        delta = 0.1 * (ticks[2] - ticks[0]);
        return ((ticks[1] - ticks[0]) < delta || (ticks[2] - ticks[1]) < delta);
    } else if (ticks[1] < now) {
        // if we only have 2, then we only care if tick 1 is < now (as otherwise our two ticks are at either end)
        // we need to check for the case where now is so far out that tick 0 and 1 clobber each other.
        delta = 0.1 * (now - ticks[0]);
        return (ticks[1] - ticks[0]) < delta;
    }
    return false;
};

GH.SprintRetrospectiveView.clearDialog = function() {
    if (GH.SprintRetrospectiveView.createRetroDialog) {
        GH.SprintRetrospectiveView.createRetroDialog._hide();
    }
};

GH.SprintRetrospectiveView.showMiniBurndown = function (data) {
    var BurndownChartController = require('jira-agile/rapid/ui/chart/burndown-chart-controller');
    var BurndownChartModel = require('jira-agile/rapid/ui/chart/burndown-chart-model');
    var Chart = require('jira-agile/rapid/ui/chart/chart');
    var ChartController = require('jira-agile/rapid/ui/chart/chart-controller');

    // first set the data
    BurndownChartModel.setRawData(data);

    if(data.warningMessage){
        // show a warning message instead of the chart
        AJS.$('#ghx-report-content')
            .prepend(GH.tpl.sprintretrospective.renderWarningMessage({
                message: data.warningMessage
            }));
        return;
    }

    // get the 2 or 3 x-axis points from the sprint dates
    var ticks = [data.startTime, data.endTime];
    if (_.isNumber(data.completeTime)) {
        ticks.push(data.completeTime);
    }
    ticks = ticks.sort();

    // if we have three values and the middle one is too close add an extra style to the container
    if (GH.SprintRetrospectiveView.doesEndDateNeedExtraRoom(ticks, data.now)) {
        AJS.$('.ghx-sprint-report-burndown').addClass('ghx-close-ticklabels');
    }

    // make the options
    var options = {
        xaxis:{
            mode:"time",
            ticks:ticks,
            reserveSpace:true
        },
        yaxis:BurndownChartModel.getYAxis(),
        series:{
            points:{
                show:false,
                radius:3,
                symbol:'circle'
            },
            lines:{
                show:true
            }
        },
        grid: {
            markings: ChartController.getNonWorkingBlocks
        }
    };

    var plotHolder = AJS.$('#ghx-report-content .ghx-sprint-report-burndown');

    // render the chart now
    var plot = Chart.draw(BurndownChartController.id, plotHolder, BurndownChartModel.getSeries(), options);

};

GH.SprintRetrospectiveView.show = function () {
    GH.ChartView.hideSpinner();
};

GH.SprintRetrospectiveView.hide = function () {

};

// this needs to be replaced with feature discovery dialog
// currently a massive hack
GH.SprintRetrospectiveView.showCreateRetrospectiveDialog = function(sprint) {
    var dialogOpts = {
        noBind : true,
        width: 320,
        addActiveClass: false,
        persistent: true,
        container: "#ghx-report-controls-group",
        calculatePositions: function (popup, targetPosition) {
            var targetOffset = targetPosition.target.offset();
            var containerOffset = AJS.$("#ghx-report-controls-group").offset();
            return {
                popupCss: {
                    top: targetOffset.top - containerOffset.top + 40,
                    left: targetOffset.left - containerOffset.left
                },
                arrowCss: {
                    left: 40
                },
                displayAbove: false
            };
        }
    };
    GH.SprintRetrospectiveView.createRetroDialog =
        GH.InlineDialog.create(
            'retroDialog',
            AJS.$("#ghx-sprint-report-meta .js-view-entity-pages"),
            GH.SprintRetrospectiveView.renderCreateRetroDialog,
            dialogOpts
        );
    GH.SprintRetrospectiveView.createRetroDialog.show();
    GH.SprintRetrospectiveView.disableRetroDialogDismissalOnBlur();
    GH.SprintRetrospectiveController.linkPagesAnalytics.show.trigger("sprint.retroDialog");

    AJS.$('.js-retro-dialog-dismiss, #ghx-sprint-report-meta .js-view-entity-pages').live('click', function(e) {
        GH.SprintRetrospectiveView.createRetroDialog._hide();
        GH.SprintRetrospectiveController.markSprintAsDismissed(sprint.id);
        GH.SprintRetrospectiveController.linkPagesAnalytics.action.trigger("sprint.retroDialog.createPage");
    });

    AJS.$(document).on('submit', '#js-create-page-form', function(e) {

        // we need to open the window from the call stack of the click handler to work around popup blocker
        var pageCreationWindow = window.open('', '_blank');

        GH.LinkedPagesService.initiateRemoteLinkConversation()
            .done(function(token) {
                var requestParams = {
                    applinkId: GH.SprintRetrospectiveView.retroApplinkData.jiraApplicationId,
                    agileMode:  'report',
                    fallbackUrl: GH.SprintRetrospectiveView.retroApplinkData.jiraUrl,
                    creationToken: token
                };
                requestParams['sprintId'] = GH.SprintRetrospectiveView.retroApplinkData.entityId;
                pageCreationWindow.location = GH.SprintRetrospectiveView.retroApplinkData.appLinkUrl + '?' + AJS.$.param(requestParams);
            });
        e.preventDefault();
    });
};

GH.SprintRetrospectiveView.renderCreateRetroDialog = function($contents, $trigger, showPopup) {
    GH.SprintRetrospectiveController.getAppLinkData().done(function(data) {
        if (data.appLinkUrl) {
            GH.SprintRetrospectiveView.retroApplinkData = data;
            $contents.html(GH.tpl.sprintretrospective.renderCreateRetroDialog(data)).addClass('ghx-inline-dialog');
            showPopup();
        }
    });
};

GH.SprintRetrospectiveView.disableRetroDialogDismissalOnBlur = function() {
    GH.SprintRetrospectiveView.createRetroDialog._hide = GH.SprintRetrospectiveView.createRetroDialog.hide;
    AJS.$(document).bind("showLayer",function(e, type, layer) {
        if (type === "inlineDialog" && layer.id === 'retroDialog') {
            AJS.$(document.body).unbind("click."+'retroDialog'+".inline-dialog-check");
            layer.hide = function() { return false; };
        }
    });
};
