GH.VelocityChartController = {};

GH.VelocityChartController.id = 'velocityChart';

GH.VelocityChartController.displayed = false;
GH.VelocityChartController.rapidViewData = {};
GH.VelocityChartController.rapidViewConfig = {};

(function () {
    var AnalyticsTracker = require('jira-agile/rapid/analytics-tracker');
    /**
     * @type module:jira-agile/rapid/analytics-tracker
     */
    GH.VelocityChartController.analytics = new AnalyticsTracker('gh.report.velocityChart');
})();

GH.VelocityChartController.setRapidView = function (rapidViewData) {
    GH.VelocityChartController.rapidViewData = rapidViewData || {};
};

GH.VelocityChartController.isApplicable = function (rapidViewConfig) {
    return rapidViewConfig.sprintSupportEnabled;
};

/**
 * Provide params to create the "normalized" object for this report
 * No params for this report
 */
GH.VelocityChartController.getNormalizedFromInternal = function () {
    return {};
};

/**
 * Interpret the normalized params and identify the relevant ones to be converted into URL params
 * No params for this report
 */
GH.VelocityChartController.toUrl = function () {
    return {};
};

/**
 * Update state from normalized state
 * @param params
 */
GH.VelocityChartController.updateInternalFromNormalized = function (params) {
    // nothing to do
};

/**
 * Get normalized state for this chart type
 */
GH.VelocityChartController.getNormalizedFromUrl = function (params) {
    return {};
};

GH.VelocityChartController.init = function () {
    // no-op
};

GH.VelocityChartController.show = function () {
    GH.log('GH.VelocityChartController.show', GH.Logger.Contexts.ui);
    GH.VelocityChartController.displayed = true;

    // stop here if haven't got a view
    if (!GH.VelocityChartController.rapidViewData) {
        return;
    }

    GH.RapidBoard.State.pushState();
    // render the view
    GH.VelocityChartController.renderChartView();

    GH.VelocityChartController.analytics.trigger("show");
};

GH.VelocityChartController.hide = function () {
    GH.log('GH.VelocityChartController.hide', GH.Logger.Contexts.ui);
    GH.VelocityChartController.displayed = false;

    GH.SprintRetrospectiveView.hide();

    // unbind listeners
    AJS.$(GH).unbind('.' + GH.VelocityChartController.id);
};

GH.VelocityChartController.renderChartView = function () {
    // controls
    GH.VelocityChartController.initializeControls();

    // render the view
    GH.ChartView.getChartContentElem(true).html(GH.tpl.velocity.renderReportBody());

    // show the spinner
    GH.ChartView.showSpinner();

    // then load the chart
    GH.VelocityChartController.loadRapidViewConfig();
};

/**
 * Initializes controls, such as time frame and filters
 */
GH.VelocityChartController.initializeControls = function () {
    // controls structure
    AJS.$('#ghx-chart-controls').hide();
};

GH.VelocityChartController.loadRapidViewConfig = function () {
    var callback = function callback(data) {
        // ignore if we are not displayed anymore
        if (!GH.VelocityChartController.displayed) {
            return;
        }
        GH.VelocityChartController.rapidViewConfig = data;
        GH.VelocityChartController.loadReportData();
    };

    GH.RapidViewConfig.fetchConfiguration(GH.VelocityChartController.rapidViewData.id).done(callback);
};

GH.VelocityChartController.loadReportData = function () {

    // load the burndown datavar
    GH.Ajax.get({
        url: '/rapid/charts/velocity.json',
        data: {
            rapidViewId: GH.VelocityChartController.rapidViewConfig.id

        }
    }, 'rapidChartData.velocity').done(GH.VelocityChartController.processChartData).fail(GH.ChartView.hideSpinner);
};

GH.VelocityChartController.processChartData = function (data) {
    if (!GH.VelocityChartController.displayed) {
        return;
    }
    // get the renderer for the estimationstatistic
    var renderer;
    if (GH.VelocityChartController.rapidViewConfig.estimationStatistic.renderer == 'duration') {
        renderer = GH.TimeFormat.formatShortDurationForTimeTrackingConfiguration;
    } else {
        renderer = GH.NumberFormat.format;
    }
    // update text values.
    _.each(data.velocityStatEntries, function (entry) {
        entry.estimated.text = renderer(entry.estimated.value);
        entry.completed.text = renderer(entry.completed.value);
    });

    GH.VelocityChartView.showVelocityChart(data);
};