/* globals AJS, GH, _ */
GH.VelocityChartView = {};

GH.VelocityChartView.showVelocityChart = function (data) {
    var BurndownChartController = require('jira-agile/rapid/ui/chart/burndown-chart-controller');
    var Chart = require('jira-agile/rapid/ui/chart/chart');

    // if we have no sprints, then shortcircuit with a message saying so
    if (data.sprints.length === 0) {
        AJS.$('#ghx-chart-content').html(GH.tpl.velocity.renderNoSprintsMessage({}));
        GH.ChartView.hideSpinner();
        return;
    }

    var estimates = [];
    var completes = [];
    var ticks = [];
    var rows = [];

    // reverse sprints, so that the most recent one is last
    var sprints = data.sprints.reverse();

    var maxStatisticValue = 0;

    // for each sprint constuct points for both series and the ticks
    _.each(sprints, function (sprint, index) {
        var statEntry = data.velocityStatEntries[sprint.id];
        var estimatedValue = statEntry.estimated.value;
        var completedValue = statEntry.completed.value;

        maxStatisticValue = Math.max(maxStatisticValue, estimatedValue, completedValue);

        estimates[index] = [index, estimatedValue];
        completes[index] = [index, completedValue];

        var formattedSprintName = GH.tpl.velocity.formatSprintName({sprintName: sprint.name});
        ticks[index] = [index, formattedSprintName];
        rows[index] = { sprint: {name: formattedSprintName,
                                 id: sprint.id
                                },
                        estimated: statEntry.estimated.text,
                        completed: statEntry.completed.text
                      };
    });

    //construct a 'series' object
    var series = [
        { label: AJS.I18n.getText("gh.rapid.velocity.chart.estimated.label"), data: estimates},
        { label: AJS.I18n.getText("gh.rapid.velocity.chart.completed.label"), data: completes}
    ];

    // hide the spinner before drawing, as flot requires that our container have height
    GH.ChartView.hideSpinner();

    // draw the chart
    var estimationStatistic = GH.VelocityChartController.rapidViewConfig.estimationStatistic;

    var plot = Chart.draw(BurndownChartController.id, GH.ChartView.getChartView(true), series, {
        series: {
            bars: {
                show:true,
                barWidth:0.2,
                align:'center',
                lineWidth:0,
                fillColor:{
                    colors: [{
                        opacity: 1
                    }, {
                        opacity: 1
                    }]
                }
            }
        },
        colors: ["#ccc", "#14892c"],
        xaxis: {
            ticks: ticks,
            min: -0.5,
            max: 6.5
        },
        yaxis: GH.FlotChartUtils.calculateYAxis(maxStatisticValue, estimationStatistic),
        legend: {
            container: null,
            position : 'ne'
        },
        multiplebars:true
    });

    var $velocityChartTable = AJS.$(GH.tpl.velocity.renderVelocityChartTable({rows: rows, rapidBoardId: GH.RapidViewConfig.currentData.id}));

    // set the chart labels
    GH.FlotChartUtils.setAndAlignAxisLabels(
        undefined,
        estimationStatistic.name
    );

    // Is this better or worse than just $velocityChartTable.find("a")? Extra method calls vs. extra dom traversal.
    var $sprintReportLinks = $velocityChartTable.find("tbody").find("tr").find(":first").find("a");
    $sprintReportLinks.mousedown(function(e) {
        if (e.which !== 1) { return; }
        var sprintId = parseInt(AJS.$(this).attr('data-value'), 10);

        GH.BoardState.setPerViewValue('sprintRetrospective.selectedSprintId', sprintId);
        GH.ReportController.selectChart(GH.SprintRetrospectiveController.id);
    });
    AJS.$('#ghx-chart-data').empty().append($velocityChartTable);

    GH.ChartView.hideSpinner();
};
