AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function () {
    var ControlChartDataService = require('jira-agile/rapid/ui/chart/v2/controlchart/control-chart-data-service');

    test('ControlChartDataService module exists', function () {
        ok(ControlChartDataService);
        ok(GH.Reports.ControlChartDataService);
    });

    module("ControlChartDataService tests", {
        DAY: 24 * 60 * 60 * 1000,
        CURRENT_TIME: Date.now(),

        setup: function setup() {
            var CURRENT_TIME = this.CURRENT_TIME;
            var DAY = this.DAY;
            var columns = this.columns = [{ id: 0, name: 'Backlog' }, { id: 1, name: 'Selected for Development' }, { id: 2, name: 'In Progress' }, { id: 3, name: 'Done' }];

            this.service = new ControlChartDataService();

            function generateIssue(key, totalTime, workingTime) {
                var leaveTimes = [CURRENT_TIME];
                _.each(totalTime.slice(1).reverse(), function (time) {
                    leaveTimes.unshift(leaveTimes[0] - time);
                });
                return {
                    key: key,
                    summary: 'summary',
                    totalTime: totalTime,
                    workingTime: workingTime,
                    leaveTimes: leaveTimes
                };
            }

            // Mock _getData to return test data
            this.service._getData = function () {
                return AJS.$.Deferred().resolve({
                    columns: columns,
                    currentTime: CURRENT_TIME,
                    issues: [generateIssue('KEY-1', [DAY, DAY, DAY, 1], [DAY, DAY, DAY, 1]), generateIssue('KEY-2', [DAY, DAY * 2, DAY * 2, DAY], [DAY, DAY, DAY, DAY]), generateIssue('KEY-3', [DAY, DAY, DAY, DAY * 30], [DAY / 2, DAY / 2, DAY / 2, DAY * 30])]
                });
            };
        }
    });

    test("Getting data for all time", function () {
        var CURRENT_TIME = this.CURRENT_TIME;
        var DAY = this.DAY;
        var filterOptions = {
            timeFrame: new GH.Reports.ChartTimeFrameModel().setAllTime(),
            refinements: new GH.Reports.ControlChartRefinementsModel().setAvailable({
                columns: this.columns
            }),
            viewingOptions: new GH.Reports.ControlChartViewingOptionsModel().fromNormalized({
                includeNonWorkingDays: true
            })
        };
        this.service.get(1, filterOptions).done(function (data) {
            // data.issues
            equal(data.issues.length, 3, "Correct number of issues are present");
            deepEqual(data.issues, [{ key: 'KEY-3', summary: 'summary', duration: DAY * 2, endTime: CURRENT_TIME - DAY * 30, columns: [{ name: 'Selected for Development', duration: DAY }, { name: 'In Progress', duration: DAY }] }, { key: 'KEY-2', summary: 'summary', duration: DAY * 4, endTime: CURRENT_TIME - DAY, columns: [{ name: 'Selected for Development', duration: DAY * 2 }, { name: 'In Progress', duration: DAY * 2 }] }, { key: 'KEY-1', summary: 'summary', duration: DAY * 2, endTime: CURRENT_TIME - 1, columns: [{ name: 'Selected for Development', duration: DAY }, { name: 'In Progress', duration: DAY }] }], "Data is tranformed correctly");

            // data.stats
            deepEqual(data.stats, {
                mean: (2 + 4 + 2) / 3 * DAY,
                median: 2 * DAY,
                min: 2 * DAY,
                max: 4 * DAY,
                rollingAverageWindow: 5
            }, "Stats are correct");

            // data.earliestTime and data.currentTime
            equal(data.earliestTime, CURRENT_TIME - DAY * 30, "Earliest end time");
            equal(data.currentTime, CURRENT_TIME, "Server current time");
        });
    });

    test("Getting data for all time with includeNonWorkingDays: false", function () {
        var CURRENT_TIME = this.CURRENT_TIME;
        var DAY = this.DAY;
        var filterOptions = {
            timeFrame: new GH.Reports.ChartTimeFrameModel().setAllTime(),
            refinements: new GH.Reports.ControlChartRefinementsModel().setAvailable({
                columns: this.columns
            }),
            viewingOptions: new GH.Reports.ControlChartViewingOptionsModel().fromNormalized({
                includeNonWorkingDays: false
            })
        };
        this.service.get(1, filterOptions).done(function (data) {
            // data.issues
            equal(data.issues.length, 3, "Correct number of issues are present");
            deepEqual(data.issues, [{ key: 'KEY-3', summary: 'summary', duration: DAY, endTime: CURRENT_TIME - DAY * 30, columns: [{ name: 'Selected for Development', duration: DAY / 2 }, { name: 'In Progress', duration: DAY / 2 }] }, { key: 'KEY-2', summary: 'summary', duration: DAY * 2, endTime: CURRENT_TIME - DAY, columns: [{ name: 'Selected for Development', duration: DAY }, { name: 'In Progress', duration: DAY }] }, { key: 'KEY-1', summary: 'summary', duration: DAY * 2, endTime: CURRENT_TIME - 1, columns: [{ name: 'Selected for Development', duration: DAY }, { name: 'In Progress', duration: DAY }] }], "Data is tranformed correctly");

            // data.stats
            deepEqual(data.stats, {
                mean: (1 + 2 + 2) / 3 * DAY,
                median: 2 * DAY,
                min: DAY,
                max: 2 * DAY,
                rollingAverageWindow: 5
            }, "Stats are correct");

            // data.earliestTime and data.currentTime
            equal(data.earliestTime, CURRENT_TIME - DAY * 30, "Earliest end time");
            equal(data.currentTime, CURRENT_TIME, "Server current time");
        });
    });

    test("Rolling series for all issues", function () {
        var DAY = this.DAY;
        var CURRENT_TIME = this.CURRENT_TIME;
        var allIssues = [{ endTime: CURRENT_TIME - 10, duration: DAY }, { endTime: CURRENT_TIME - 9, duration: 2 * DAY }, { endTime: CURRENT_TIME - 8, duration: 3 * DAY }, { endTime: CURRENT_TIME - 7, duration: 4 * DAY }, { endTime: CURRENT_TIME - 6, duration: 3 * DAY }, { endTime: CURRENT_TIME - 5, duration: 2 * DAY }, { endTime: CURRENT_TIME - 4, duration: DAY }, { endTime: CURRENT_TIME - 3, duration: 2 * DAY }, { endTime: CURRENT_TIME - 2, duration: 3 * DAY }, { endTime: CURRENT_TIME - 1, duration: 4 * DAY }];
        var filterOptions = {
            timeFrameTimes: { from: CURRENT_TIME - 10, to: CURRENT_TIME }
        };
        var results = ControlChartDataService._calculateRollingSeries(allIssues, allIssues, filterOptions);
        strictEqual(results.rollingAverageWindow, 5);
        deepEqual(results.rollingAverageLine, [[CURRENT_TIME - 10, 6 / 3], [CURRENT_TIME - 9, 10 / 4], [CURRENT_TIME - 8, 13 / 5], [CURRENT_TIME - 7, 14 / 5], [CURRENT_TIME - 6, 13 / 5], [CURRENT_TIME - 5, 12 / 5], [CURRENT_TIME - 4, 11 / 5], [CURRENT_TIME - 3, 12 / 5], [CURRENT_TIME - 2, 10 / 4], [CURRENT_TIME - 1, 9 / 3],
        // Additional point to extend to end of selected timeframe
        [CURRENT_TIME, 9 / 3]]);
    });

    test("Rolling series for subset of issues", function () {
        var DAY = this.DAY;
        var CURRENT_TIME = this.CURRENT_TIME;
        var allIssues = [{ endTime: CURRENT_TIME - 10, duration: DAY }, { endTime: CURRENT_TIME - 9, duration: 2 * DAY }, { endTime: CURRENT_TIME - 8, duration: 3 * DAY }, { endTime: CURRENT_TIME - 7, duration: 4 * DAY }, { endTime: CURRENT_TIME - 6, duration: 3 * DAY }, { endTime: CURRENT_TIME - 5, duration: 2 * DAY }, { endTime: CURRENT_TIME - 4, duration: DAY }, { endTime: CURRENT_TIME - 3, duration: 2 * DAY }, { endTime: CURRENT_TIME - 2, duration: 3 * DAY }, { endTime: CURRENT_TIME - 1, duration: 4 * DAY }];
        var filterOptions = {
            timeFrameTimes: { from: CURRENT_TIME - 7, to: CURRENT_TIME - 3 }
        };
        var results = ControlChartDataService._calculateRollingSeries(allIssues, allIssues.slice(3, 7), filterOptions);
        strictEqual(results.rollingAverageWindow, 5);
        deepEqual(results.rollingAverageLine, [[CURRENT_TIME - 7, 14 / 5], [CURRENT_TIME - 6, 13 / 5], [CURRENT_TIME - 5, 12 / 5], [CURRENT_TIME - 4, 11 / 5], [CURRENT_TIME - 3, 12 / 5]]);
    });
});