GH.Reports = GH.Reports || {};
GH.Reports.controlChartHowTo = function () {
    // Each plot should have 8 points
    var x = _.range(8);
    var outlier = c3.circlePlot().data(_.zip(x, [0, 2, 1, 1.5, 2, 0, 11, 1.2])).xDomain([-1, 8]).yDomain([-2, 14]).elementClass('issue').update(function (event) {
        event.selection.each(function (d) {
            // Highlight the outlier
            if (d[1] === 11) {
                d3.select(this).classed('active', true);
            }
        });
    });
    var decreasing = c3.linePlot().data(_.zip(x, [7, 5, 5.5, 3.5, 4, 3, 3, 2])).yDomain([0, 10]).elementClass('control-chart-aggregate-mean');
    var narrowingRollingAverage = [4, 6, 3, 4, 5, 4, 4.5, 4];
    var narrowingDeviation = [4, 4, 3.5, 2, 2, 1.5, 1, 1];
    var narrowing = c3.layerable().xDomain([0, x.length - 1]).yDomain([0, 10]).addLayer('standard-deviation', c3.deviationPlot().data(_.zip(x, narrowingRollingAverage, narrowingDeviation)).elementClass('standard-deviation')).addLayer('rolling-average', c3.linePlot().data(_.zip(x, narrowingRollingAverage)).elementClass('control-chart-aggregate-mean'));

    return c3.component('controlChartHowTo').extend(GH.Reports.multipleCharts()).extend(function () {
        this.selection().selectAll(this.chartSelector()).classed('ghx-control-chart-svg', true);
    }).charts([outlier, decreasing, narrowing]);
};