GH.SavedFilterPicker = function (options) {
    this.selector = options.selector;
    this.fieldSelector = options.selector + "-field";
    this.blurHandler = options.blur;
    this.selectHandler = options.selected;
    this.stayActivated = options.stayActivated;
    this.focus = options.focus;
};

GH.SavedFilterPicker.prototype.show = function (currentFilter) {
    // create the single-select frother to replace it (edit mode)
    var $select = AJS.$(this.selector);
    var singleSelect = new AJS.SingleSelect({
        element: $select,
        width: 300,
        removeOnUnSelect: true,
        itemAttrDisplayed: "label",
        errorMessage: '',
        ajaxOptions: {
            query: true, // this is vital, otherwise it only queries _once_ and then never again
            url: GH.Ajax.buildRestUrl('/savedfilter/list.json'),
            formatResponse: function formatResponse(response) {
                if (response.errors) {
                    var errors = GH.Ajax._convertJiraErrors(response.errors);
                    var contexts = {
                        'searchName': this.selector
                    };
                    GH.Ajax.handleContextualErrors(errors, contexts);
                    return false;
                }

                // clear out potential previous errors
                $select.siblings(".ghx-error").remove();

                // build the values for the frother to display
                var ret = [];
                AJS.$(response.filters).each(function () {
                    ret.push(new AJS.ItemDescriptor({
                        // value of item added to select
                        value: this.id.toString(),
                        // title of lozenge -- This is already HTML-escaped by SingleSelect, so no need to do it here
                        label: this.name,
                        // html used in suggestion -- This is NOT HTML-escaped by SingleSelect, so we must do so explicitly
                        html: AJS.escapeHTML(String(this.name)),
                        savedFilter: this
                    }));
                });
                return ret;
            }
        }
    });
    this.singleSelect = singleSelect;

    // make sure that when the edit field blurs, the frother goes away and we return
    // to display mode
    var removeFunction = this.removeSingleSelect;
    if (!this.stayActivated) {
        AJS.$(this.fieldSelector).blur(function () {
            removeFunction(singleSelect);
        });
    }

    // set up blur handler
    if (_.isFunction(this.blurHandler)) {
        AJS.$(this.fieldSelector).blur(this.blurHandler);
    }

    // focus on the edit field
    if (this.focus) {
        AJS.$(this.fieldSelector).focus().select();
    }

    if (currentFilter) {
        this.setSelection(currentFilter);
    }

    // listen to the 'selected' event the frother fires to save the data
    var selectFunction = this.selectHandler;

    if (!this.stayActivated) {
        $select.bind('selected', function (event, selected) {
            removeFunction(singleSelect);
            selectFunction(event, selected);
        });
        $select.bind('unselect', function (event, selected) {
            removeFunction(singleSelect);
            selectFunction(event, selected);
        });
    } else {
        $select.bind('selected', selectFunction);
        $select.bind('unselect', selectFunction);
    }
};

GH.SavedFilterPicker.prototype.setSelection = function (currentFilter) {
    this.singleSelect.setSelection(new AJS.ItemDescriptor({
        value: currentFilter.id.toString(),
        label: currentFilter.name,
        html: AJS.escapeHTML(String(currentFilter.name)),
        savedFilter: currentFilter,
        selected: true
    }));
};

GH.SavedFilterPicker.prototype.removeSingleSelect = function (singleSelect) {
    singleSelect.hideSuggestions();
    singleSelect.disable();
};

GH.SavedFilterPicker.prototype.getElement = function () {
    return this.singleSelect.$field;
};