define('jira-agile/rapid/ui/component/sprintactions/sprint-actions', ['require'], function(require) {
    'use strict';
    var $ = require('jquery');
    var _ = require('underscore');
    var BacklogModel = require('jira-agile/rapid/ui/plan/backlog-model');
    var SprintController = require('jira-agile/rapid/ui/plan/sprint-controller');
    var Dropdown = AJS.Dropdown;

    var SprintActions = function () {};

    SprintActions.CORE_SPRINT_ACTIONS = {
        'gh-sprint-move-up': SprintController.moveSprintUp,
        'gh-sprint-move-down': SprintController.moveSprintDown,
        'gh-sprint-delete': SprintController.deleteSprint,
        'gh-sprint-add-goal': SprintController.addGoal,
        'gh-sprint-add-goal-disabled': $.noop,
        'gh-sprint-delete-disabled': $.noop
    };

    SprintActions.prototype = {

        createDropdown: function() {
            var self = this;
            Dropdown.create({
                trigger: $('.js-sprint-actions-trigger'),
                ajaxOptions: {
                    dataType: 'json',
                    cache: false,
                    formatSuccess: function(json) {
                        var sprintId = json.id;
                        var sprintData = self.getSprintData(sprintId);
                        json.sections = self.filterActions(json.sections, sprintData);
                        let $content =  $(GH.tpl.component.sprintactions.sprintActionsDropdown(json));
                        $content.find('.js-sprint-action').tooltip({
                            html: true
                        });
                        return $content;
                    }
                }
            });

            $(document).off('click', '.js-sprint-action');
            $(document).on('click', '.js-sprint-action', function(e) {
                self.clickSprintAction(e);
            });
        },

        getSprintData: function(sprintId) {
            var canMoveUp = false;
            var canMoveDown = false;
            var futureSprints = BacklogModel.getFutureSprintModels();
            var sprintModel = BacklogModel.getSprintModel(sprintId);
            if (futureSprints.length > 1 && sprintModel.isFutureSprint()) {
                canMoveUp = futureSprints[0].getSprintId() !== sprintId;
                canMoveDown = _.last(futureSprints).getSprintId() !== sprintId;
            }
            return {
                'canMoveUp': canMoveUp,
                'canMoveDown': canMoveDown,
                'canManageSprints': BacklogModel.canManageSprints()
            };
        },

        filterActions: function(sections, sprintData) {
            _.each(sections, function(section) {
                section.actions = _.reject(section.actions, function(action) {
                    return (action.id === 'gh-sprint-move-up' && !(sprintData.canMoveUp && sprintData.canManageSprints)) ||
                            (action.id === 'gh-sprint-move-down' && !(sprintData.canMoveDown && sprintData.canManageSprints));
                });

                _.each(section.actions, function(action) {
                    action.disabled = action.styleClass && action.styleClass.indexOf('disabled') >= 0;
                });
            });

            return _.filter(sections, function(section) {
                return section.actions.length > 0;
            });
        },

        clickSprintAction: function(event) {
            var $action = $(event.currentTarget);
            var sprintId = $action.data('sprint-id');
            var actionId = $action.attr('id');
            var actionHandler = SprintActions.CORE_SPRINT_ACTIONS[actionId];
            if (actionHandler) {
                event.preventDefault();
                actionHandler(sprintId);
            }
        }
    };

    return SprintActions;
});
