AJS.test.require('com.pyxis.greenhopper.jira:gh-rapid-tests', function () {
    var DialogsOverrider = null;
    var Events = require("jira/util/events");

    module('DialogsOverrider.js', {
        setup: function setup() {
            this.submitCallback = sinon.spy();
            sinon.stub(GH.DetailsObjectFactory, 'getDetailsModel').returns({
                viewData: {
                    id: 1
                }
            });
            DialogsOverrider = require('jira-agile/rapid/ui/detail/inlineedit/dialogsoverrider');
            DialogsOverrider.init(this.submitCallback);
            DialogsOverrider.DIALOG_OVERRIDE_LIST = ['test-dialog', 'agile-dialog'];

            this.dialog = {
                isIssueDialog: function isIssueDialog() {
                    return true;
                },
                options: {
                    id: 'test-dialog',
                    onDialogFinished: sinon.spy()
                },

                show: function show() {
                    Events.trigger('Dialog.show', [AJS.$(), this]);
                },

                submit: function submit() {
                    this.options.onDialogFinished();
                },

                hide: sinon.spy()
            };
        },

        teardown: function teardown() {
            DialogsOverrider.destroy();
            GH.DetailsObjectFactory.getDetailsModel.restore();
        }
    });

    test('Test that submit calls provided callback', function () {
        this.dialog.show();
        this.dialog.submit();

        ok(!this.dialog.options.onDialogFinished.called, "Original submit handler was NOT called.");
        ok(this.submitCallback.calledOnce, "Dialog callback was called.");
        ok(this.dialog.hide.calledOnce, "Dialog was hidden on submit.");
    });

    test('Test dialog with incorrect ID does not call callback.', function () {
        this.dialog.options.id = 'different-dialog';
        this.dialog.show();
        this.dialog.submit();

        ok(this.dialog.options.onDialogFinished.calledOnce, "Original submit handler was called.");
        ok(!this.submitCallback.called, "Provided dialog callback was NOT called");
    });

    test('Dialog that is not an issue dialog, but expected Agile dialog does call provided callback.', function () {
        this.dialog.options.id = 'agile-dialog';

        this.dialog.isIssueDialog = function () {
            return false;
        };

        this.dialog.show();
        this.dialog.submit();

        ok(!this.dialog.options.onDialogFinished.called, "Original submit handler was NOT called.");
        ok(this.submitCallback.calledOnce, "Provided dialog callback was called");
        ok(this.dialog.hide.calledOnce, "Dialog was hidden on submit.");
    });

    test('Dialog that is not an issue dialog nor expected Agile dialog does not call provided callback.', function () {
        this.dialog.options.id = 'not-agile-dialog';

        this.dialog.isIssueDialog = function () {
            return false;
        };

        this.dialog.show();
        this.dialog.submit();

        ok(this.dialog.options.onDialogFinished.calledOnce, "Original submit handler was called.");
        ok(!this.submitCallback.called, "Provided dialog callback was NOT called");
    });

    test('calling init without destroying is a no-op.', function () {
        DialogsOverrider.init(this.submitCallback);
        DialogsOverrider.init(this.submitCallback);

        this.dialog.show();
        this.dialog.submit();

        ok(!this.dialog.options.onDialogFinished.called, "Original submit handler was NOT called.");
        ok(this.submitCallback.calledOnce, "Dialog callback was called.");
    });

    test('calling init after destroying successfully inits with new callback.', function () {
        var newCallback = sinon.spy();

        DialogsOverrider.destroy();
        DialogsOverrider.init(newCallback);

        this.dialog.show();
        this.dialog.submit();

        ok(!this.dialog.options.onDialogFinished.called, "Original submit handler was NOT called.");
        ok(newCallback.calledOnce, "New dialog callback was called.");
        ok(!this.submitCallback.called, "Old callback was not called.");
    });
});