define('jira-agile/rapid/ui/detail/legacy/legacy-details-model', [
    'require'
], function(
    require
) {
    'use strict';

    var _ = require('underscore');
    var DetailsModel = require('jira-agile/rapid/ui/detail/details-model');

    var LegacyDetailsModel = {};

    /**
     * Returns the Primary Tracking Statistic field object, if one exists; false otherwise
     */
    LegacyDetailsModel.getPrimaryTrackingStatisticField = function() {
        if (this.fieldSections['tracking'].length === 0) {
            return false;
        }

        var trackingFields = this.getFieldsForSection('tracking');
        return trackingFields[0];
    };

    /**
     * Returns a list of the Secondary Tracking Statistic field objects; empty array if there are none.
     * These fields will be displayed in the Inline Time Tracking dialog
     */
    LegacyDetailsModel.getSecondaryTrackingStatisticFields = function() {
        if (this.fieldSections['tracking'].length < 2) {
            return [];
        }

        var trackingFields = this.getFieldsForSection('tracking');
        return trackingFields.slice(1);
    };

    /**
     * Process the fields that were returned in the view data and assign them to their correct field sections
     * @param viewData
     */
    LegacyDetailsModel.processFields = function(viewData) {
        // initialise sections
        this.fieldSections = {
            header      : [],
            estimate    : [],
            tracking    : [],
            details     : [],
            people      : [],
            dates       : [],
            links       : [],
            description : []
        };

        // get the configured estimate statistic and tracking statistic IDs
        var estimateStatisticFieldId = viewData.primaryStatisticFieldId || "";
        var trackingStatisticFieldId = viewData.trackingStatisticFieldId || "";

        var timeTrackingFieldIds = [];
        var timeTrackingWithSubtasks = false;

        _.forEach(viewData.fields, function(field) {
            if (field.id === estimateStatisticFieldId) {
                this.fieldSections.estimate.push(field.id);
            } else if (field.id === trackingStatisticFieldId) {
                timeTrackingFieldIds.push(field.id);
            } else if (field.id === 'aggregatetimeestimate' || field.id === 'aggregatetimeestimate_subtasks') {
                timeTrackingFieldIds.push(field.id);
                timeTrackingWithSubtasks = true;
            } else {
                var section = this.FIELD_SECTION_PRESETS[field.id];
                section = section || field.category || 'details';
                if (section !== 'unsupported') {
                    this.fieldSections[section].push(field.id);
                }
            }
        }.bind(this));

        // figure out which time tracking field to display as the tracking statistic field
        var primaryTrackingFieldPicker;
        if (timeTrackingFieldIds.length > 0 && timeTrackingWithSubtasks) {
            primaryTrackingFieldPicker = function(fieldId) { return fieldId === 'aggregatetimeestimate'; };

        } else if (timeTrackingFieldIds.length > 0) {
            primaryTrackingFieldPicker = function(fieldId) { return fieldId === trackingStatisticFieldId; };
        }

        if (!_.isUndefined(primaryTrackingFieldPicker)) {
            // pick the primaryId
            var primaryId = _.find(timeTrackingFieldIds, primaryTrackingFieldPicker);

            // leave the rest
            var secondaryIds = _.reject(timeTrackingFieldIds, primaryTrackingFieldPicker);

            // ensure the primaryId field is the first one in the section
            var trackingFields = [];
            trackingFields.push(primaryId);

            // add the other time tracking fields afterwards
            if (timeTrackingWithSubtasks) {
                trackingFields = trackingFields.concat(secondaryIds);
            }

            this.fieldSections.tracking = trackingFields;

        }
    };

    /**
     * Helper function to escape the comments restrictions roles
     */
    LegacyDetailsModel.escapeCommentsRestriction = function(comments) {
        for (var i = 0; i < comments.length; i++) {
            var role = comments[i].restrictedTo;
            // role is null if there is no restriction
            if (role) {
                comments[i].restrictedTo = AJS.escapeHTML(String(role));
            }
        }
    };

    return _.extend(DetailsModel, LegacyDetailsModel);
});
