GH.Dialogs.CompleteParentDialog = {};

GH.Dialogs.CompleteParentDialog.EVENT_PARENT_COMPLETED = "parentCompleted";

GH.Dialogs.CompleteParentDialog.showDialog = function (issue, transitions, columnData) {
    AJS.dim();
    AJS.$('.aui-blanket').html('<span class="ghx-wait"></span>');
    GH.Dialogs.CompleteParentDialog.renderDialog(issue, transitions, columnData.name);
};

/**
 * Renders the "complete sprint" dialog where the details of the new version can be specified
 *
 * @param model : see CompleteParentViewModel
 */
GH.Dialogs.CompleteParentDialog.renderDialog = function (issue, transitions, columnName) {
    // create the dialog
    var dialog = GH.Dialog.create({
        width: 500,
        height: 250,
        id: 'ghx-dialog-complete-parent'
    });
    dialog.addHeader(AJS.I18n.getText('gh.parent.complete.dialog.title', issue.key));
    dialog.addPanel('', 'panel');

    dialog.getCurrentPanel().html(GH.tpl.dialogs.completeparent.renderCompleteParentDialog({
        issue: issue,
        transitions: transitions,
        columnName: AJS.escapeHTML(String(columnName))
    }));

    if (transitions.length > 0) {
        dialog.addButton(AJS.I18n.getText('gh.parent.complete.dialog.update.button.label'), function () {
            dialog.disableControls();
            if (transitions.length == 1) {
                GH.Dialogs.CompleteParentDialog.complete(dialog, issue, transitions[0].id);
            } else {
                GH.Dialogs.CompleteParentDialog.complete(dialog, issue, AJS.$(".js-complete-parent").find("input:checked").val());
            }
        }, 'aui-button');

        GH.Dialog.addCancelButton(dialog);
    } else {
        dialog.addButton(AJS.I18n.getText('gh.parent.complete.dialog.ok.button.label'), function () {
            dialog.disableControls();
            dialog.dispose();
        }, 'aui-button');
    }

    AJS.$('.aui-dialog').addClass('ghx-dialog');

    dialog.show();
    AJS.$('.aui-blanket').empty();

    AJS.$("#ghx-release-name").focus();
};

/**
 * Complete sprint
 */
GH.Dialogs.CompleteParentDialog.complete = function (dialog, issue, transitionId) {
    GH.IssueOperationShortcuts.setOverrideSelectedIssue(issue);
    dialog.dispose();
    GH.WorkDragAndDrop.executeWorkflowTransition(issue.id, transitionId);
};