AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function () {
    module("showDialog", {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
            GH.Dialog.undim();
            GH.Notification.clear();
        }
    });

    test("Successful Ajax request renders the dialog", sinon.test(function () {
        this.stub(GH.Dialogs.CompleteSprintDialog, "renderDialog");

        GH.Test.respondToGetWith200(this, "/sprint/2/complete", {});

        GH.Dialogs.CompleteSprintDialog.showDialog(1, 2);

        this.server.respond();

        ok(GH.Dialogs.CompleteSprintDialog.renderDialog.called, "Called success method");
    }));

    test("Failed request calls undim", sinon.test(function () {
        this.stub(GH.Dialogs.CompleteSprintDialog, "renderDialog");
        this.stub(AJS, "undim");

        GH.Test.respondToGetWith500(this, "/sprint/complete/model.json", {});

        GH.Dialogs.CompleteSprintDialog.showDialog();

        this.server.respond();

        ok(!GH.Dialogs.CompleteSprintDialog.renderDialog.called, "Does not call process function on failure");
        ok(AJS.undim.called);
    }));

    test("complete: Successful AJAX call disposes the dialog", sinon.test(function () {

        GH.Test.respondToPutWith200(this, "/sprint/2/complete", {});

        var dialog = {};
        dialog.dispose = this.stub();
        dialog.enableControls = this.stub();

        GH.Dialogs.CompleteSprintDialog.complete(dialog, { rapidViewId: 1, sprint: { id: 2 } });

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(dialog.dispose.called, "Called success method");
        ok(!dialog.enableControls.called, "Did not call error method");
    }));

    test("complete: Failed AJAX call enables dialog controls (no specific error handler)", sinon.test(function () {

        GH.Test.respondToPostWith500(this, "/sprint/complete", {});

        var dialog = {};
        dialog.hideSpinner = this.stub();
        dialog.enableControls = this.stub();

        GH.Dialogs.CompleteSprintDialog.complete(dialog, { rapidViewId: 1, sprint: { id: 2 } });

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(dialog.hideSpinner.called, "Called failure method: Spinner is hidden");
        ok(dialog.enableControls.called, "Called failure method: Controls are enabled");
    }));
});