// Creates a customised AJS.Dialog that can be used to ask a user to confirm a choice.

GH.ConfirmDialog = {};

/**
 *  Dialog options:
 *  id: dialog ID for element
 *  header: text for title of dialog
 *  content: text for the message in the dialog
 *  onConfirmFn: function to call if the user clicks OK
 *  onCancelFn: function to call if the user clicks Cancel
 */
GH.ConfirmDialog.create = function(id, dialogOptions) {

    var defaultOpts = {
        header: AJS.I18n.getText("gh.rapid.operations.confirmation"),
        content: AJS.I18n.getText("gh.generic.confirmation"),
        contentEscaping: true,
        onConfirmFn: function() {},
        onCancelFn: function() {},
        width: 433,
        height: 184
    };

    var opts = _.defaults(dialogOptions, defaultOpts);

    var dialog = GH.Dialog.create({
        id: id,
        width: opts.width,
        height: opts.height,
        closeOnOutsideClick: false,
        onCancelFn: opts.onCancelFn
    });

    dialog.addHeader(opts.header);

    var content;
    if (opts.contentEscaping) {
        content = AJS.$("<div />").text(opts.content);
    } else {
        content = AJS.$("<div />").html(opts.content);
    }

    dialog.addPanel("", content, "ghx-confirm-dialog-panel");

    dialog.addButton(AJS.I18n.getText("gh.rapid.operations.confirm"), function(dialog) {
        // call dispose instead of remove to do the full handling of dialog removal
        dialog.dispose();

        // execute confirmation after removing dialog
        opts.onConfirmFn();
    }, "aui-button");

    GH.Dialog.addCancelButton(dialog);
    AJS.$('#'+dialog.id).addClass('ghx-dialog');

    return dialog;
};
