/**
 * Welcome Mat view controller
 */
GH.Dialog.FindView = {};

(function () {
    var AnalyticsTracker = require('jira-agile/rapid/analytics-tracker');
    /**
     * @type module:jira-agile/rapid/analytics-tracker
     */
    GH.Dialog.FindView.analytics = new AnalyticsTracker('gh.welcome.find.view');
})();

GH.Dialog.FindView.init = function () {
    GH.Dialog.registerDialog('.js-find-view', GH.Dialog.FindView.openFindExistingViewDialog);
};

/**
 * Opens the dialog to create a new project, filter and rapid view
 */
GH.Dialog.FindView.openFindExistingViewDialog = function () {
    // cancel callback
    var onCancelFn = function onCancelFn(dialog) {
        // analytics for cancel tracking
        GH.Dialog.FindView.analytics.trigger('cancel', dialog.curpage.toString()); // SAFE
    };

    // create the dialog
    var dialog = GH.Dialog.create({
        width: 600,
        height: 215,
        id: 'ghx-welcome-dialog-view-find',
        onCancelFn: onCancelFn
    });

    // analytics for find project dialog
    dialog.eventCategory = "gh.welcome.find.view";
    GH.Dialog.FindView.analytics.trigger('start'); // SAFE

    // add one step to the dialog
    GH.Dialog.FindView.showFindViewStep(dialog);

    // return to the first page/panel
    dialog.gotoPage(0);
    dialog.gotoPanel(0);
    dialog.show();

    // put focus on the first input element
    AJS.$("#ghx-welcome-find-viewname-field").focus();

    // this causes the user picker frother single select to be created
    // JIRA.trigger(JIRA.Events.NEW_CONTENT_ADDED, [dialog.getCurrentPanel().body]);
    AJS.$(dialog.getCurrentPanel().body).trigger("contentRefresh");
};

/**
 * Find an Existing View
 */
GH.Dialog.FindView.showFindViewStep = function (dialog) {
    dialog.addHeader(AJS.I18n.getText('gh.rapid.welcome.view.find'));
    AJS.$('#' + dialog.id).addClass('ghx-dialog');

    var page = AJS.$(GH.tpl.findviewdialog.renderFindExistingView());

    dialog.addPanel(AJS.I18n.getText('gh.rapid.welcome.view.find'), page, 'ghx-welcome-page');
    dialog.addButton(AJS.I18n.getText('gh.rapid.operations.go'), GH.Dialog.FindView.validateViewFind, 'aui-button');

    // bind the form submit to the same handler as the go button
    page.find("form").submit(function () {
        GH.Dialog.FindView.validateViewFind(dialog);
        return false;
    });

    var singleSelect = new AJS.SingleSelect({
        element: AJS.$("#ghx-welcome-find-viewname"),
        width: 300,
        removeOnUnSelect: true,
        overlabel: AJS.I18n.getText('gh.rapid.view.select.board.name'),
        itemAttrDisplayed: "label",
        errorMessage: '',
        ajaxOptions: {
            query: true,
            url: GH.Ajax.buildRestUrl('/rapidviews/list.json'),
            formatResponse: function formatResponse(response) {
                var ret = [];
                AJS.$(response.views).each(function () {
                    ret.push(new AJS.ItemDescriptor({
                        // value of item added to select
                        value: this.id.toString(),
                        // title of lozenge -- This is already HTML-escaped by SingleSelect, so no need to do it here
                        label: this.name,
                        // html used in suggestion -- This is NOT HTML-escaped by SingleSelect, so we must do so explicitly
                        html: AJS.escapeHTML(String(this.name))
                    }));
                });
                return ret;
            }
        }
    });

    // add cancel button
    GH.Dialog.addCancelButton(dialog);
};

/**
 * Do some validation on the view selected
 */
GH.Dialog.FindView.validateViewFind = function (dialog) {
    var view = {
        id: AJS.$('#ghx-welcome-find-viewname').val()
    };
    var errorContextMap = {
        'viewName': '#ghx-welcome-find-viewname'
    };
    var successFn = function successFn() {
        // analytics for complete find view dialog
        GH.Dialog.FindView.analytics.trigger('complete'); // SAFE

        GH.RapidBoard.gotoRapidBoardPage(view.id);
    };

    AJS.$(dialog.getCurrentPanel().body).find('.ghx-error').remove();
    GH.Ajax.get({
        url: 'welcome/validateViewFind',
        data: view,
        errorContextMap: errorContextMap
    }, "validateViewFind").done(successFn);
};