/**
 * Holds the code for the remove issue from sprint dialog
 */
GH.RemoveIssuesFromSprintDialog = {};
GH.RemoveIssuesFromSprintDialog.Analytics = {};

(function () {
    var AnalyticsTracker = require('jira-agile/rapid/analytics-tracker');
    /**
     * @type module:jira-agile/rapid/analytics-tracker
     */
    GH.RemoveIssuesFromSprintDialog.Analytics.remove = new AnalyticsTracker('gh.sprint.issue.remove');
})();

/**
 * Constructs a dialog for the given model
 */
GH.RemoveIssuesFromSprintDialog.constructDialog = function (removeFromSprintModel, deferred) {
    // define the base dialog
    var dialog = GH.Dialog.create({
        width: 600,
        height: 250,
        id: 'ghx-remove-issues-from-sprint',
        onCancelFn: function onCancelFn(dialog) {
            // analytics for cancel tracking
            deferred.reject(removeFromSprintModel);
        }
    });

    // fetch the params for the dialog
    var totalNumberOfIssues = _.reduce(removeFromSprintModel.changes, function (memo, change) {
        return memo + change.issueKeys.length;
    }, 0);

    dialog.addHeader(AJS.I18n.getText('gh.sprint.issue.move.dialog.title', totalNumberOfIssues));
    dialog.addPanel('', 'panel');

    // render the dialog
    var html = GH.tpl.dialogs.removeissuesfromsprint.renderRemoveIssuesFromSprintsDialog(removeFromSprintModel);

    dialog.getCurrentPanel().html(html);

    var buttonTitle = AJS.I18n.getText('gh.rapid.operations.confirm');
    dialog.addButton(buttonTitle, function () {
        dialog.disableControls();
        dialog.dispose();
        deferred.resolve(removeFromSprintModel);
    }, 'aui-button');
    GH.Dialog.addCancelButton(dialog);
    dialog.show();
    dialog.updateHeight();
    // focus on the first button in the button bar
    AJS.$('#' + dialog.id).find('.dialog-button-panel .button-panel-cancel-link').focus();
};