/**
 * Epic view component.
 */
GH.EpicQuickCreate = {};

GH.EpicQuickCreate.quickCreateReset = true;

GH.EpicQuickCreate.createModel = function() {
    GH.EpicQuickCreate.Model = JIRA.Forms.CreateIssueModel.extend({

        /**
         * Gets active fields. For Create Issue, this means all required fields also
         */
        getActiveFieldIds: function () {
            var instance = this,
                deferred = jQuery.Deferred(),
                activeFieldIds = [];

            // put together the fields we want to show
            var userfields = [];
            userfields.push('summary');
            userfields.push(GH.EpicConfig.getEpicLabelFieldId());

            //this.getUserFields().done(function (userfields) {

            jQuery.each(userfields, function (i, fieldId) {
                activeFieldIds.push(fieldId);
            });

            instance.getRequiredFields().done(function (requiredFields) {
                jQuery.each(requiredFields, function (i, requiredField) {
                    if (jQuery.inArray(requiredField.id, activeFieldIds) === -1) {
                        activeFieldIds.push(requiredField.id);
                    }
                });
                deferred.resolve(activeFieldIds);
            });
            //});

            return deferred.promise();
        },
        // override the check of user preferences - always use custom fields
        getUseConfigurableForm: function() {
            var deferred = jQuery.Deferred();
            deferred.resolve(true);

            return deferred.promise();
        },
        // override so that existing user preferences are not affected
        setUseConfigurableForm: function() {
        }
    });
};

GH.EpicQuickCreate.resetQuickCreate = function() {
    if (!GH.EpicQuickCreate.quickCreateReset) {
        // prevent this function from being called again before the next remember
        // it is bound to the hide dialog event which is triggered twice on hide
        // but we only want to make one ajax call
        GH.EpicQuickCreate.quickCreateReset = true;

        GH.EpicQuickCreate.storeQuickCreateDefaults(GH.EpicQuickCreate.createFormPreferences);
    }
};

GH.EpicQuickCreate.rememberQuickCreateDefaults = function() {
    if (GH.EpicQuickCreate.quickCreateReset) {
        // prevent this function from being called again before the next reset
        GH.EpicQuickCreate.quickCreateReset = false;

        var setFormPreferences = function(data) {
            GH.EpicQuickCreate.createFormPreferences = data;
        };

        GH.EpicQuickCreate.loadQuickCreateDefaults().done(setFormPreferences);
    }
};

GH.EpicQuickCreate.storeQuickCreateDefaults = function(defaults) {
    return GH.Ajax.put({
        url: '/userData/quickEditDefaults',
        data: defaults
    });
};

GH.EpicQuickCreate.loadQuickCreateDefaults = function() {
    return GH.Ajax.get({
        url:'/userData/quickEditDefaults'
    }, "quickEditDefaults");
};


/**
 * Factory to create Create Epic Form
 *
 * @return JIRA.Forms.Container
 */
GH.EpicQuickCreate.createCreateEpicForm = function (options) {

    options = options || {};

    return new JIRA.Forms.Container(function () {

        options.globalEventNamespaces = options.globalEventNamespaces || ["QuickCreateEpic"];

        // model that gets fields and sets user preferences
        var title = AJS.I18n.getText('gh.epic.operations.create.title', GH.EpicConfig.getEpicIssueTypeName()),
            model = new GH.EpicQuickCreate.Model({
                projectId: options.pid,
                issueType: options.issueType
            }),
            configurableForm = new JIRA.Forms.ConfigurableCreateIssueForm({
                model: model,
                title: title,
                globalEventNamespaces: options.globalEventNamespaces
            }),
            unconfigurableForm = new JIRA.Forms.UnconfigurableCreateIssueForm({
                model: model,
                title: title,
                globalEventNamespaces: options.globalEventNamespaces
            });

        return {
            globalEventNamespaces: options.globalEventNamespaces,
            model: model,
            errorHandler: new JIRA.Forms.CreateIssueError(),
            configurableForm: configurableForm,
            unconfigurableForm: unconfigurableForm
        };
    });
};

AJS.$(GH).bind('issueCreated', function(event, data) {
    // Thanks to the wonders that is JIRA, we now have an issue key but not idea about the field data for the issue we *just* created
    // We now have to do yet another request in order to retrieve the information that we just sent to the server
    // JRADEV-16435 has been raised, and will probably be fixed sometime mid 2015.

    var updateDefaultIssueTypeId = function(quickCreateData) {
        GH.UserData.quickCreateDefaultIssueTypeId = quickCreateData.issueTypeId;
    };

    GH.EpicQuickCreate.loadQuickCreateDefaults().done(updateDefaultIssueTypeId);
});

GH.EpicQuickCreate.createCreateStoryForm = function() {
    var issueTypeId = GH.UserData.quickCreateDefaultIssueTypeId;

    if (issueTypeId === GH.EpicConfig.getEpicIssueTypeId()) {
        issueTypeId = GH.EpicConfig.getStoryIssueTypeId();
    }

    return JIRA.Forms.createCreateIssueForm({
        issueType: issueTypeId
    });
};

GH.EpicQuickCreate.registerCreateEpicDialog = function() {
    // Browse project issue types

    // sanity check as CreateIssueModel isn't available on the dashboard
    if (JIRA && JIRA.Forms && JIRA.Forms.CreateIssueModel) {
        GH.EpicQuickCreate.createModel();

        var $epicColumn = AJS.$("#ghx-epic-column");
        $epicColumn.find('.js-create-epic').each(function () {
            var quickCreate = GH.EpicQuickCreate.createCreateEpicForm({
                //pid: $trigger.attr("data-pid"),
                issueType: GH.EpicConfig.getEpicIssueTypeId()
            });
            var dialog = quickCreate.asDialog({
                windowTitle: AJS.I18n.getText('gh.epic.operations.create.title', GH.EpicConfig.getEpicIssueTypeName()),
                trigger: this,
                id: 'create-epic-issue-dialog'
            });
            // Reset preferences for issue type and fields display in create issue dialog
            dialog.bind("Dialog.show", GH.EpicQuickCreate.rememberQuickCreateDefaults);
            dialog.bind("Dialog.hide", GH.EpicQuickCreate.resetQuickCreate);
        });
    } else {
        GH.log("Tried to initialise Epic Quick Create but JIRA CreateIssueModel was not loaded");
    }
};
