// Add analytics to links in the user profile dropdown to GreenHopper's documentation and Agile Answers.
AJS.$(function() {
    var AnalyticsTracker = require('jira-agile/rapid/analytics-tracker');
    var analytics = function(category) {
        return new AnalyticsTracker(category).setAsync(false);
    };

    // bind to click to fire analytics event
    AJS.$('#gh_view_help').click(function (e) {
        analytics('gh.gethelp').trigger('usermenu', 'docs'); // SAFE
        return deferredLink(AJS.$(this));
    });

    AJS.$('#greenhopper-my-jira-home-enablement').click(function (e) {
        analytics('gh.myjirahome').trigger('usermenu', 'enabled'); // SAFE
        return deferredLink(AJS.$(this));
    });

    AJS.$('#greenhopper-my-jira-home-enablement-ondemand').click(function (e) {
        analytics('gh.myjirahome').trigger('usermenu', 'set'); // SAFE
        return deferredLink(AJS.$(this));
    });
    AJS.$('#greenhopper-my-jira-home-disablement-ondemand').click(function (e) {
        analytics('gh.myjirahome').trigger('usermenu', 'disable'); // SAFE
        return deferredLink(AJS.$(this));
    });

    AJS.$('#greenhopper-my-jira-home-set').click(function (e) {
        analytics('gh.myjirahome').trigger('usermenu', 'set'); // SAFE
        return deferredLink(AJS.$(this));
    });

    // analytics for enabling/disabling the Rapid Removal labs feature
    AJS.$('#beta_gh\\.configuration\\.rapid\\.removal').click(function (e) {
        var input = AJS.$(this),
            state = input.attr('checked') ? "on" : "off";

        // TODO This isn't used any more since Rapid Boards aren't a labs feature
        // HOWEVER it would be good to make this work for any arbitrary labs feature
        analytics('gh.labs.feature').trigger('rapid_removal', state); // SAFE
        return true;
    });

    // analytics for the "Classic..." link in new Agile menu
    AJS.$(document).delegate('#js-classic-link_lnk', 'click', function (e) {
        analytics("gh.agile.menu").trigger('classic'); // SAFE

        // note that even though this is a 'link', we can't use the deferred link method as the user might want to open it
        // in a separate tab/window. the analytics event is synchronous, so we _should_ see events coming through before
        // the browser navigates to the new page
        return true;
    });

    // go to HREF after a small delay to ensure analytics are processed
    var deferredLink = function($a) {
    	if($a.attr('target') == '_blank') {
    		return true;
    	} else {
    		setTimeout('document.location = "' + $a.attr('href') + '"', 100);
    		return false;
    	}
    };

});
