/* global _, GH, JIRA */

/**
 * A dialog showing work assigned to each person for a given sprint.
 * @module jira-agile/rapid/ui/plan/assigned-work-dialog
 * @requires module:underscore
 * @requires module:jira/dialog/form-dialog
 */
define('jira-agile/rapid/ui/plan/assigned-work-dialog', ['require'], function(require) {
    'use strict';

    var _ = require('underscore');
    var FormDialog = require('jira/dialog/form-dialog');

    /**
     * @constructor
     * @param {Object} options
     * @param {Object[]} options.assignedWorkStats
     * @param {string} options.sprintName
     * @param {string} options.estimateStatisticName
     */
    var AssignedWorkDialog = FormDialog.extend({
        _getDefaultOptions: function() {
            return _.extend(this._super(), {
                content: function(setContent) {
                    var html = GH.tpl.assignedWorkDialog.renderDialogContents({
                        assignedWorkStats: this.options.assignedWorkStats,
                        sprintName: this.options.sprintName,
                        estimateStatisticName: this.options.estimateStatisticName,
                        trackingStatisticName: this.options.trackingStatisticName
                    });
                    setContent(html);
                }
            });
        }
    });

    return AssignedWorkDialog;
});