define('jira-agile/rapid/ui/plan/issue-flag-and-comment-action', [
    'jira/dialog/form-dialog',
    'jira/dialog/dialog-util',
    'jquery',
    'underscore'
], function(
    FormDialog,
    DialogUtil,
    $,
    _
) {
    function formSubmissionHandler(issueKeys, flag, formSubmissionCallback) {
        return function(e) {
            e.preventDefault();
            var dialog = this;

            var $commentField = $('#flag-and-add-comment-dialog').find('.jira-dialog-content form .comment-input');
            var trimmedComment = $commentField.find('textarea').val().trim();
            var comment = trimmedComment ? GH.tpl.dialog.flagandcomment.comment({
                isAdd: flag,
                content: trimmedComment
            }) : '';

            var $formToken = $('#flag-and-add-comment-dialog').find('[name="formToken"]');
            var formToken  = $formToken.val();
            var temporaryAttachments = $('#flag-and-add-comment-dialog input[name="filetoconvert"]').toArray().map(function (el) {return $(el).val();});

            // If there is no selected visibility (which occurs when there is no selector),
            // allow all users to view the comment.
            var selectedVisibility = $commentField.find('.security-level select option:selected').val();
            var commentVisibility = selectedVisibility ? selectedVisibility : '';

            GH.IssueActions.flag(issueKeys, flag, comment, commentVisibility, formToken, temporaryAttachments)
                .always(function() {
                    dialog.hide();
                }).done(formSubmissionCallback);
        };
    }

    function getDialogTitle(issueKeys, flag) {
        return flag ?
            AJS.I18n.getText('gh.rapid.operations.flag.and.comment.dialog.title', issueKeys.length) :
            AJS.I18n.getText('gh.rapid.operations.unflag.and.comment.dialog.title', issueKeys.length);
    }

    function decorateFormDialog(issueKeys, flag) {
        return function() {
            var $dialog = $('#flag-and-add-comment-dialog');
            $dialog.find('.jira-dialog-heading > h2').html(getDialogTitle(issueKeys, flag)).removeAttr('title');

            var $dialogContent = $dialog.find('.jira-dialog-content');
            $dialogContent.prepend(GH.tpl.dialog.flagandcomment.dialogHeader({
                isAdd: flag,
                issueKeys: issueKeys.join(', ')
            }));

            var $form = $dialogContent.find('form');
            $form.addClass('ajs-dirty-warning-exempt');

            var $formFooter = $dialog.find('.form-footer');
            $formFooter.find('p').remove();
            $formFooter.find('.aui-button[type="submit"]').addClass('aui-button-primary');
        };
    }

    function createDialog(issueKeys, flag, formSubmissionCallback) {
        var dialog = new FormDialog({
            id: "flag-and-add-comment-dialog",
            url: AJS.contextPath() + "/secure/GHBulkCommentDialog.jspa?issueKeys=" + encodeURIComponent(issueKeys.join(",")),
            submitHandler: formSubmissionHandler(issueKeys, flag, formSubmissionCallback),
            handleRedirect: true,
            ajaxOptions: DialogUtil.getDefaultAjaxOptions,
            isIssueDialog: true,
            widthClass: "large"
        });

        dialog.onContentReady(decorateFormDialog(issueKeys, flag));
        return dialog;
    }

    var IssueFlagAndCommentAction = {};

    IssueFlagAndCommentAction.execute = function(issueKeys, flag, formSubmissionCallback) {
        if (!_.isArray(issueKeys)) {
            issueKeys = [issueKeys];
        }

        createDialog(issueKeys, flag, formSubmissionCallback).show();
    };

    return IssueFlagAndCommentAction;
});

AJS.namespace('GH.IssueFlagAndCommentAction.execute', null, require('jira-agile/rapid/ui/plan/issue-flag-and-comment-action').execute);
