AJS.test.require(["com.pyxis.greenhopper.jira:gh-rapid", 'com.pyxis.greenhopper.jira:gh-test-common'], function () {
    var PlanIssueListFiltering = require('jira-agile/rapid/ui/plan/plan-issue-list-filtering');
    var IssueListModel = require('jira-agile/rapid/ui/plan/issue-list-model');
    var _ = require('underscore');

    test("module 'jira-agile/rapid/ui/plan/plan-issue-list-filtering' exists", function () {
        ok(PlanIssueListFiltering);
        ok(GH.PlanIssueListFiltering);
    });

    test('No filters', function (assert) {
        var issueKeys = ['PROJ-1', 'PROJ-2', 'PROJ-3'];
        var model = new IssueListModel('model', GH.IssueTest.issueObjectsFromKeys(issueKeys));

        PlanIssueListFiltering.applyToIssueList(model);
        var filteredIssues = model.getVisibleIssues();

        assert.deepEqual(Object.keys(filteredIssues), issueKeys);
    });

    test('Filter epics with sub-tasks', function (assert) {
        var epic = GH.IssueTest.createIssueObject({ key: 'EPIC-1', hidden: false });
        var parent = GH.IssueTest.createIssueObject({ key: 'PROJ-1', epic: 'EPIC-1'});
        var otherIssue = GH.IssueTest.createIssueObject({ key: 'PROJ-4' });
        var subtasks = GH.IssueTest.issueObjectsFromKeys(['PROJ-2', 'PROJ-3'])
            .map(issue => _.defaults({ parentKey: 'PROJ-1', parent: parent }, issue));
        var model = new IssueListModel('model', [parent, otherIssue].concat(subtasks));

        GH.EpicController.init();
        GH.EpicController.setEpicData({ epics: [epic] });
        PlanIssueListFiltering.setEpicFilter('EPIC-1');
        PlanIssueListFiltering.applyToIssueList(model);
        var filteredIssues = model.getVisibleIssues();

        assert.deepEqual(Object.keys(filteredIssues), ['PROJ-1', 'PROJ-2', 'PROJ-3']);
    });
});
