/* globals
 * GH.tpl, GH.Tooltip, GH.DetailsView, GH.ViewActions, GH.GridDataController
 */

/**
 * @module jira-agile/rapid/ui/plan/plan-view
 * @requires module:jquery
 * @requires module:jira-agile/rapid/ui/plan/plan-controls
 * @requires module:jira-agile/rapid/ui/plan/plan-controller
 * @requires module:jira-agile/rapid/ui/kanplan/kan-plan-feature-service
 */
define('jira-agile/rapid/ui/plan/plan-view', ['require'], function (require) {
    'use strict';

    var $ = require('jquery');
    var GlobalEvents = require('jira-agile/rapid/global-events');
    var PlanControls = require('jira-agile/rapid/ui/plan/plan-controls');
    var KanPlanAcknowledge = require('jira-agile/rapid/ui/kanplan/kanplan-acknowledge');
    var KanPlanFeatureService = require('jira-agile/rapid/ui/kanplan/kan-plan-feature-service');
    var BacklogView;
    var PlanController;

    // Resolve circular dependency
    GlobalEvents.on("pre-initialization", function () {
        PlanController = require('jira-agile/rapid/ui/plan/plan-controller');
        BacklogView = require('jira-agile/rapid/ui/plan/BacklogView');
    });

    var PlanView = {};

    /**
     * Initializes the view controller.
     */
    PlanView.init = function () {
        var $document = $(document);
        // version panel toggle
        $document.delegate('.js-view-action-toggle-releases-column, .js-release-toggle', 'click', PlanController.toggleVersionsColumn);
        // epic panel toggle
        $document.delegate('.js-view-action-toggle-epics-column, .js-epic-toggle', 'click', PlanController.toggleEpicsColumn);
        $document.delegate('.js-view-actions-plan .js-view-action-toggle-epics-lozenge', 'click', PlanController.toggleEpicsShowOnBacklog);
    };

    /**
     * Called when the work tab is shown
     */
    PlanView.show = function () {
        PlanView.detailViewPositioned = false;

        // Flag the Mode
        $('body').addClass('ghx-mode-planning');

        // enable the fixed element listener
        //    PlanView.updateScrollResizeHandler();

        // create a skeleton DOM for widgets
        var skeleton = GH.tpl.plancontroller.renderSkeleton({
            // Whether to render the entire container of epics and versions
            shouldShowEpicAndVersionPanels: GH.RapidBoard.State.isScrumBoard() || KanPlanFeatureService.isEpicsAndVersionsEnabled(),
            // Whether to render epics panel inside the epics and versions container
            shouldShowEpicPanel: PlanController.isEpicsPanelEnabled()
        });

        $('#ghx-plan').empty().append(skeleton);

        var versionToggleAffordance = $('.js-release-toggle');
        GH.Tooltip.tipsify({
            selector: versionToggleAffordance,
            gravity: 'w',
            html: true,
            className: 'ghx-tipsy-alt'
        });

        var epicToggleAffordance = $('.js-epic-toggle');
        GH.Tooltip.tipsify({
            selector: epicToggleAffordance,
            gravity: 'w',
            html: true,
            className: 'ghx-tipsy-alt'
        });

        // Configure the detail view
        GH.DetailsView.setContainerSelector('#ghx-detail-view');
        GH.DetailsView.setOptions({
            canClose: true,
            showActionsCog: true,
            showSubtaskTab: true,
            showLogWorkTrigger: false,
            updateSizeHandler: PlanView.updateDetailViewSize,
            closeHandler: PlanController.closeDetailsView
        });

        if (GH.RapidBoard.State.isKanbanBoard()) {
            KanPlanAcknowledge.show();

            PlanView.updateEpicsAndVersionsColumnBorder();
        }

        // ensure we reset the container the next time we get it since it's been redrawn
        delete BacklogView.container;
    };

    PlanView.updateEpicsAndVersionsColumnBorder = function () {
        // Hide the left border in #ghx-backlog so there is no double line shown
        if (!KanPlanFeatureService.isEpicsAndVersionsEnabled() && !PlanController.isEpicsColumnVisible() && !PlanController.isVersionsColumnVisible()) {
            $('#ghx-plan-group').toggleClass('ghx-no-epic-menu-and-no-version-menu', true);
        }
    }, PlanView.updateDetailViewState = function () {
        var opened = PlanController.isDetailsViewOpened();
        if (opened) {
            $('#ghx-plan-group').addClass('ghx-has-detail');
            $('#ghx-detail-view').css({ 'display': '' });
        } else {
            $('#ghx-plan-group').removeClass('ghx-has-detail');
            $('#ghx-detail-view').css({ 'display': 'none' });
        }
        GH.ViewActions.setDetailViewVisible(opened);
    };

    PlanView.updateVersionColumnState = function () {
        var $column = $('#ghx-version-column');
        var flagpole = $('#ghx-plan-group');
        var versionToggleAffordance = $('.js-release-toggle');
        var versionColumnVisible = PlanController.isVersionsColumnVisible() && PlanController.isVersionsPanelEnabled();
        if (versionColumnVisible) {
            $column.css({ 'display': '' });
            flagpole.addClass('ghx-version-expanded');
            versionToggleAffordance.addClass('ghx-active');
            GH.Tooltip.disable(versionToggleAffordance);
        } else {
            $column.css({ 'display': 'none' });
            flagpole.removeClass('ghx-version-expanded');
            versionToggleAffordance.attr('data-tooltip', GH.tpl.plancontroller.renderVersionPanelTipsyExpand()).removeClass('ghx-active');
            GH.Tooltip.enable(versionToggleAffordance);
        }
        GH.ViewActions.setVersionsPanelVisible(versionColumnVisible);
        BacklogView.adjustStickyHeader();
    };

    PlanView.updateEpicsColumnState = function () {
        var $column = $('#ghx-epic-column');
        var flagpole = $('#ghx-plan-group');
        var epicsToggleAffordance = $('.js-epic-toggle');
        var epicsColumnVisible = PlanController.isEpicsColumnVisible() && PlanController.isEpicsPanelEnabled();

        if (epicsColumnVisible) {
            $column.css({ 'display': '' });
            flagpole.addClass('ghx-epic-expanded');
            epicsToggleAffordance.addClass('ghx-active');
        } else {
            $column.css({ 'display': 'none' });
            flagpole.removeClass('ghx-epic-expanded');
            epicsToggleAffordance.attr('data-tooltip', GH.tpl.plancontroller.renderEpicPanelTipsyExpand()).removeClass('ghx-active');
        }
        GH.ViewActions.setEpicsPanelVisible(epicsColumnVisible);
        BacklogView.adjustStickyHeader();
    };

    PlanView.updateViewActions = function () {
        GH.ViewActions.setDetailViewVisible(PlanController.isDetailsViewOpened());
        GH.ViewActions.setEpicsPanelVisible(PlanController.isEpicsColumnVisible());
        GH.ViewActions.setVersionsPanelVisible(PlanController.isVersionsColumnVisible());
        if (GH.GridDataController.getModel()) {
            GH.ViewActions.setSwimlanes(GH.GridDataController.getModel().hasSwimlanes());
        }
    };

    PlanView.updateHorizontalPositioning = function () {
        GH.DetailsView.updateSize();
    };

    /**
     * Resize the detailViewContainer size.
     */
    // TODO: now that all sizes are properly set outside, we can move all the resize logic into the detail view
    // proper and handle it there. Clean this up as soon as we remove all other resize code!
    PlanView.updateDetailViewSize = function () {

        // set contents height @todo why do we have this duplicated per mode? = this is the same for plan and work
        var detailIssue = $('#ghx-detail-issue');
        if (detailIssue.length > 0) {
            var detailIssueHeight = detailIssue.outerHeight();
            var detailHead = $('#ghx-detail-head');
            var detailHeadHeight = detailHead.outerHeight();
            var detailContents = $('#js-detail-nav-content');
            detailContents.css({ 'height': detailIssueHeight - detailHeadHeight - 13 }); // if you work out where the magic number comes from tell me
        }
    };

    PlanView.doUpdateDetailsView = function () {
        // ensure the detail view is properly laid out (this is only necessary the first time after we show the tab,
        // after that resize handlers will take care of re-layouting)
        if (!PlanView.detailViewPositioned) {
            PlanView.detailViewPositioned = true;
            PlanView.updateFixedElementPositioning();
        }
    };

    /**
     * Called when the work tab is hidden
     */
    PlanView.hide = function () {

        // UnFlag the Mode
        $('body').removeClass('ghx-mode-planning');

        // empty our DOM
        $('#ghx-plan').empty();
    };

    // transitions

    /**
     * CSS Class Removal for Loading Transition on QF
     */
    PlanView.hideLoadingFilter = function () {
        $('body').removeClass('ghx-loading-quickfilter');
    };

    /**
     * CSS Class for Pool Loading Transition
     */
    PlanView.showLoadingBacklog = function () {
        $('body').addClass('ghx-loading-backlog');
        $('.ghx-throbber').spin('large');
    };

    /**
     * CSS Class Removal for Pool Loading Transition
     */
    PlanView.hideLoadingBacklog = function () {
        $('body').removeClass('ghx-loading-backlog');
        $('.ghx-throbber').spin(false);
    };

    /**
     * Updates all columns marked as fixed to ensure they fit within the content view area
     */
    PlanView.updateFixedElementPositioning = function () {
        // if not visible don't do anything
        if (!PlanController.isVisible) {
            return;
        }

        // update Quick Filter toggle spacing
        PlanControls.resizeQuickFilters({ mode: 'plan' });

        // update all horizontal positioning
        PlanView.updateHorizontalPositioning();
    };

    return PlanView;
});