AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common","com.pyxis.greenhopper.jira:gh-rapid"],function(){var t=require("jira-agile/rapid/ui/plan/sprint-controller"),e=require("jira-agile/rapid/ui/plan/backlog-controller"),r=require("jira-agile/rapid/ui/plan/backlog-model"),i=require("jira-agile/rapid/ui/plan/BacklogView"),n=(require("jquery"),require("jira-agile/rapid/global-events"));n.trigger("pre-initialization"),module("Ajax tests",{setup:function(){this.sandbox=sinon.sandbox.create(),GH.Test.setUpFakeServer(this),e.rapidViewData={id:1}},teardown:function(){GH.Test.restoreServer(this),this.sandbox.restore()}}),test("SprintController module exists",function(){ok(t),ok(GH.SprintController)}),test("addSprint: Successful AJAX call adds a new sprint in the backlog model and updates the view",sinon.test(function(){this.stub(r,"addNewSprint"),this.stub(i,"updateSprintsAfterAddRemove");var e=new RegExp("^"+GH.Ajax.buildRestUrl("/sprint/1"));this.server.respondWith("POST",e,[200,{"Content-Type":"application/json"},JSON.stringify({})]),t.addSprint(),this.server.respond(),ok(r.addNewSprint.called,"Called success method"),ok(i.updateSprintsAfterAddRemove.called,"Called success method")})),test("addSprint: Failed AJAX call does nothing (no error handling)",sinon.test(function(){this.stub(r,"addNewSprint"),this.stub(i,"updateSprintsAfterAddRemove");var e=new RegExp("^"+GH.Ajax.buildRestUrl("/sprint/1"));this.server.respondWith("POST",e,[500,{"Content-Type":"application/json"},JSON.stringify({})]),t.addSprint(),this.server.respond(),ok(!r.addNewSprint.called,"Nothing called when ajax fails"),ok(!i.updateSprintsAfterAddRemove.called,"Nothing called when ajax fails")})),test("doDeleteSprint: Sends correct Ajax call",sinon.test(function(){this.stub(r,"removeSprintAndMoveIssues"),this.stub(i,"updateSprintsAfterAddRemove");var e=new RegExp("^"+GH.Ajax.buildRestUrl("/sprint/6"));this.server.respondWith("DELETE",e,[200,{"Content-Type":"application/json"},JSON.stringify({})]),t.doDeleteSprint(5,6),this.server.respond(),ok(r.removeSprintAndMoveIssues.called),ok(i.updateSprintsAfterAddRemove.called)})),test("moveSprintDown: Successful AJAX call updates the backlog model and updates the view",sinon.test(function(){var e=42,n=54;this.sandbox.stub(r,"moveSprintDown").withArgs(e).returns(n),this.sandbox.stub(i,"updateSprintsAfterAddRemove");var s=new RegExp("^"+GH.Ajax.buildRestUrl("/sprint/"+e+"/swap"));this.server.respondWith("PUT",s,[204,{"Content-Type":"application/json"},JSON.stringify({})]),t.moveSprintDown(e),this.server.respond(),ok(r.moveSprintDown.called,"Called mutating method"),ok(i.updateSprintsAfterAddRemove.called,"Called success method")})),test("moveSprintDown: Failed AJAX call updates the backlog model twice and updates the view twice",sinon.test(function(){var e=42,n=54,s=this.sandbox.mock(r);s.expects("moveSprintDown").once().withArgs(e).returns(n),s.expects("moveSprintDown").once().withArgs(n).returns(e),this.sandbox.stub(i,"updateSprintsAfterAddRemove");var a=new RegExp("^"+GH.Ajax.buildRestUrl("/sprint/"+e+"/swap"));this.server.respondWith("PUT",a,[401,{"Content-Type":"application/json"},JSON.stringify({})]),t.moveSprintDown(e),this.server.respond(),s.verify(),sinon.assert.callCount(i.updateSprintsAfterAddRemove,2)})),test("moveSprintUp: Successful AJAX call updates the backlog model and updates the view",sinon.test(function(){var e=42,n=54;this.sandbox.stub(r,"moveSprintUp").withArgs(e).returns(n),this.sandbox.stub(i,"updateSprintsAfterAddRemove");var s=new RegExp("^"+GH.Ajax.buildRestUrl("/sprint/"+e+"/swap"));this.server.respondWith("PUT",s,[204,{"Content-Type":"application/json"},JSON.stringify({})]),t.moveSprintUp(e),this.server.respond(),ok(r.moveSprintUp.called,"Called mutating method"),ok(i.updateSprintsAfterAddRemove.called,"Called success method")})),test("moveSprintUp: Failed AJAX call updates the backlog model twice and updates the view twice",sinon.test(function(){var e=42,n=54,s=this.sandbox.mock(r);s.expects("moveSprintUp").once().withArgs(e).returns(n),s.expects("moveSprintUp").once().withArgs(n).returns(e),this.sandbox.stub(i,"updateSprintsAfterAddRemove");var a=new RegExp("^"+GH.Ajax.buildRestUrl("/sprint/"+e+"/swap"));this.server.respondWith("PUT",a,[401,{"Content-Type":"application/json"},JSON.stringify({})]),t.moveSprintUp(e),this.server.respond(),s.verify(),sinon.assert.callCount(i.updateSprintsAfterAddRemove,2)}));var s={state:"ACTIVE"},a={state:"FUTURE"};module("trigger analytics events"),test("Move between active sprints",sinon.test(function(){this.stub(t.analytics,"trigger");var e={changes:[{currentSprint:s,targetSprint:s}]};t.triggerAnalytics(e),ok(t.analytics.trigger.calledWith("movebetweenactivesprints"))})),test("Move between future sprints",sinon.test(function(){this.stub(t.analytics,"trigger");var e={changes:[{currentSprint:a,targetSprint:a}]};t.triggerAnalytics(e),ok(t.analytics.trigger.calledWith("movebetweenfuturesprints"))})),test("Move from future to active sprint",sinon.test(function(){this.stub(t.analytics,"trigger");var e={changes:[{currentSprint:a,targetSprint:s}]};t.triggerAnalytics(e),ok(t.analytics.trigger.calledWith("movefromfuturetoactivesprint"))})),test("Move from active to future sprint",sinon.test(function(){this.stub(t.analytics,"trigger");var e={changes:[{currentSprint:s,targetSprint:a}]};t.triggerAnalytics(e),ok(t.analytics.trigger.calledWith("movefromactivetofuturesprint"))})),test("Move in backlog",sinon.test(function(){this.stub(t.analytics,"trigger");var e={changes:[{currentSprint:null,targetSprint:null}]};t.triggerAnalytics(e),ok(!t.analytics.trigger.called)})),test("Add to future sprint",sinon.test(function(){this.stub(t.analytics,"trigger");var e={changes:[{currentSprint:null,targetSprint:a}]};t.triggerAnalytics(e),ok(t.analytics.trigger.calledWith("addtofuturesprint"))})),test("Add to active sprint",sinon.test(function(){this.stub(t.analytics,"trigger");var e={changes:[{currentSprint:null,targetSprint:s}]};t.triggerAnalytics(e),ok(t.analytics.trigger.calledWith("addtoactivesprint"))})),test("Remove from future sprint",sinon.test(function(){this.stub(t.analytics,"trigger");var e={changes:[{currentSprint:a,targetSprint:null}]};t.triggerAnalytics(e),ok(t.analytics.trigger.calledWith("removefromfuturesprint"))})),test("Remove from active sprint",sinon.test(function(){this.stub(t.analytics,"trigger");var e={changes:[{currentSprint:s,targetSprint:null}]};t.triggerAnalytics(e),ok(t.analytics.trigger.calledWith("removefromactivesprint"))})),module("ColumnConfigAnalytics tests",{setup:function(){this.context=AJS.test.mockableModuleContext(),this.jiraAnalytics={send:sinon.spy()},this.RAPID_VIEW_ID=23,this.BacklogController={rapidViewData:{id:this.RAPID_VIEW_ID}},this.context.mock("jira/analytics",this.jiraAnalytics),this.context.mock("jira-agile/rapid/ui/plan/backlog-controller",this.BacklogController),this.context.mock("jira-agile/rapid/global-events",n),this.sprintController=this.context.require("jira-agile/rapid/ui/plan/sprint-controller"),n.trigger("pre-initialization")},teardown:function(){},assertTrigger:function(t){ok("Spy should be called once",this.jiraAnalytics.send.calledOnce);var e=this.jiraAnalytics.send.getCall(0).args[0];equal(e.name,"jira-software.scrum.plan.issuecard.dnd","Name of event should be valid"),deepEqual(e.properties,t,"Properties should be equal")}}),test("should send target and current sprint id",function(){var t={changes:[{currentSprint:{id:"currentSprintId"},targetSprint:{id:"targetSprintId"},issueKeys:["a"],doneIssueKeys:[]}]};this.sprintController.triggerAnalyticsIssuesDnD(t),this.assertTrigger({issues:1,currentSprintId:"currentSprintId",targetSprintId:"targetSprintId",boardId:this.RAPID_VIEW_ID})}),test("should send -1 when sprint is null",function(){var t={changes:[{targetSprint:null,issueKeys:["a"],doneIssueKeys:["b"]}]};this.sprintController.triggerAnalyticsIssuesDnD(t),this.assertTrigger({issues:2,currentSprintId:-1,targetSprintId:-1,boardId:this.RAPID_VIEW_ID})})});