AJS.test.require('com.pyxis.greenhopper.jira:gh-rapid', function () {

    var IssueListUtil = require('jira-agile/rapid/ui/work/issue-list-util');

    module('IssueListUtil', {
        ELLIPSIS: '\u2026',
        assertDisplayIssueKey: function (issueKey, charWidth, availWidth, expectedDisplayKey) {
            var result = IssueListUtil.buildDisplayIssueKey(issueKey, {
                approxCharacterWidth: charWidth,
                availableWidth: availWidth
            });
            strictEqual(result, expectedDisplayKey);
        }
    });

    test('buildDisplayIssueKey truncates issue key when there is not enough space', function () {
        this.assertDisplayIssueKey('ABCD-123', 1, 7, 'AB' + this.ELLIPSIS + '-123');
        this.assertDisplayIssueKey('ABCD-123', 1, 6, 'A' + this.ELLIPSIS + '-123');
        this.assertDisplayIssueKey('ABCD-123', 1, 5, this.ELLIPSIS + '-123');
        this.assertDisplayIssueKey('ABCD-123', 1, 4, this.ELLIPSIS);
    });

    test('buildDisplayIssueKey does not truncate when there is enough space', function () {
        this.assertDisplayIssueKey('ABCD-123', 1, 8, 'ABCD-123');
        this.assertDisplayIssueKey('ABCD-123', 7, 100, 'ABCD-123');
    });

    test('buildDisplayIssueKey handles widths of null and 0', function () {
        this.assertDisplayIssueKey('ABCD-123', 0, 1, 'ABCD-123');
        this.assertDisplayIssueKey('ABCD-123', 0, 0, 'ABCD-123');
        this.assertDisplayIssueKey('ABCD-123', 10, 0, this.ELLIPSIS);
        this.assertDisplayIssueKey('ABCD-123', null, null, 'ABCD-123');
    });

});