AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid-config"], function () {
    var WorkRanking = require('jira-agile/rapid/ui/work/work-ranking');

    module("Ajax tests", {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
        }
    });

    test("rankIssues: Successful AJAX call calls callback", sinon.test(function () {

        this.stub(GH.WorkController, "reload");
        this.stub(GH.RankingModel, "reorderIssues");
        this.stub(GH.SwimlaneView, "rerenderCellOfIssue");

        var callback = this.stub();

        GH.Test.respondToPutWith200(this, "/rank", {});

        WorkRanking.rankIssues([], 1, 2, callback);

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(callback.called, "Called success method");
        ok(!GH.WorkController.reload.called, "Does not call error method");
    }));

    test("rankIssues: Failed AJAX call does nothing (no error handling)", sinon.test(function () {

        this.stub(GH.WorkController, "reload");
        this.stub(GH.RankingModel, "reorderIssues");
        this.stub(GH.SwimlaneView, "rerenderCellOfIssue");

        var callback = this.stub();

        GH.Test.respondToPutWith500(this, "/rank", {});

        WorkRanking.rankIssues([], 1, 2, callback);

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(!callback.called, "Nothing called when ajax fails");
        ok(GH.WorkController.reload.called, "Calls error method");
    }));
});