/* global QUnit, require, _ */
AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common', 'com.pyxis.greenhopper.jira:gh-rapid', 'com.pyxis.greenhopper.jira:gh-test-dates'], function() {
    var ChartPicker = require('jira-agile/rapid/ui/component/chart-picker');
    var GlobalEvents = require('jira-agile/rapid/global-events');
    var VersionReportController = require('jira-agile/rapid/ui/chart/version-report-controller');

    GlobalEvents.trigger('pre-initialization');

    function clearCachedElements() {
    }

    module('Version report', {
        setup: function() {
            GH.Test.setUpFakeServer(this);
            sinon.stub(AJS.$, 'plot').returns({
                getXAxes: function() { return [{}]; },
                getYAxes: function() { return [{}]; },
                hooks: {
                    drawSeries: [],
                    draw: []
                }
            });
        },
        teardown: function() {
            GH.Test.restoreServer(this);
            clearCachedElements();
            AJS.$.plot.restore();
        }
    });

    test('loads the version picker and selects the correct version', sinon.test(function() {
        QUnit.GhFixtures.addFixture('<div id="ghx-chart-selector"></div>');

        GH.Test.respondToGetWith200(this, '/xboard/plan/backlog/versions.json', GH.AjaxTest.Data.VersionList);
        GH.Test.respondToGetWith200(this, '/xboard/config.json', GH.AjaxTest.Data.SampleScrumBoardConfig);

        // Ensure no selected version id is stored
        this.stub(ChartPicker.prototype, 'getStoredSelectedItemId').returns(null);

        // call the functions in the order that we expect them to be called when page loads
        VersionReportController.init();
        VersionReportController.setRapidView({ id: 1});
        VersionReportController.show();

        this.server.respond();
        this.server.respond();

        ok(GH.Test.VersionReport.hasTriggerForVersionPicker(), 'Should have a version picker');

        var projectId = _.keys(GH.AjaxTest.Data.VersionList.versionData.versionsPerProject)[0];
        var versionsPerProject = GH.AjaxTest.Data.VersionList.versionData.versionsPerProject[projectId];
        ok(GH.Test.VersionReport.selectedVersionIs(versionsPerProject[0]), 'Selected Version is correct');

        ok(GH.Test.VersionReport.pickerChoicesInclude(versionsPerProject[1]), 'Includes choice for second version');
        ok(GH.Test.VersionReport.pickerChoicesInclude(versionsPerProject[2]), 'Includes choice for third version');
    }));

    test('Displays the version meta and chart', sinon.test(function() {
        var versionData = GH.AjaxTest.Data.ReleasedVersionProgressChart;
        GH.Test.respondToGetWith200(this, '/xboard/config.json', GH.AjaxTest.Data.SampleScrumBoardConfig);
        GH.Test.respondToGetWith200(this, '/xboard/plan/backlog/versions.json', GH.AjaxTest.Data.VersionList);
        GH.Test.respondToGetWith200(this, '/rapid/charts/versionprogresschart', versionData);
        GH.Test.respondToGetWith200(this, '/rapid/charts/versionreport', GH.AjaxTest.Data.ReleasedVersionReport);
        GH.Test.respondToGetWith200(this, '/rapidviewconfig/workingdays/rates', {});

        QUnit.GhFixtures.addFixture('<section id="ghx-chart-content"></section>');

        VersionReportController.init();
        VersionReportController.setRapidView({ id: 1});
        VersionReportController.show();

        this.server.respond();
        this.server.respond();
        this.server.respond();
        this.server.respond();
        this.server.respond();

        ok(GH.Test.VersionReport.displayingMeta());
        ok(GH.Test.VersionReport.metaTextTranslated());
    }));
});
