/**
 * Creates a GH.GridDataModel with basic data.
 *
 * Usage:
 * var model = GH.Test.Builders.gridDataModel().withIssue(issue).build();
 * To add other configurable properties, add functions within the model that is returned.
 */
GH.Test.Builders.gridDataModel = function () {

    // ensure there is a column
    var defaultColumnId = 101;
    var columns = [{ id: defaultColumnId }];
    var columnIssueMapping = {};
    columnIssueMapping[defaultColumnId] = [];

    // ensure there is one swimlane
    var defaultSwimlaneId = 102;
    var swimlanes = [{ id: defaultSwimlaneId }];
    var swimlaneIssueMapping = {};
    swimlaneIssueMapping[defaultSwimlaneId] = [];

    var issues = {};
    var order = [];
    var variables = {};

    var addIssue = function addIssue(issueObj) {
        issues[issueObj.key] = issueObj;
        order.push(issueObj.key);
        columnIssueMapping[defaultColumnId].push(issueObj.key);
    };

    var model = {
        withIssue: function withIssue(issueObj) {
            addIssue(issueObj);
            swimlaneIssueMapping[defaultSwimlaneId].push(issueObj.key);
            return model;
        },
        withParentIssue: function withParentIssue(issueObj) {
            variables.swimlanesType = "parentChild";
            addIssue(issueObj);
            swimlanes.push({
                defaultSwimlane: false,
                id: issueObj.id,
                parentKey: issueObj.key
            });
            swimlaneIssueMapping[issueObj.id] = [];
            return model;
        },
        withSubtask: function withSubtask(issueObj) {
            addIssue(issueObj);
            // will fail if the parent swimlane doesn't exist
            swimlaneIssueMapping[issueObj.parentId].push(issueObj.key);
            return model;
        },
        build: function build() {
            return new GH.GridDataModel(columns, columnIssueMapping, swimlanes, swimlaneIssueMapping, issues, order, variables);
        }
    };

    return model;
};