/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.indexanalyzer.impl;

import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.plugins.indexanalyzer.impl.DBActiveIssuesIterator;
import com.atlassian.jira.plugins.indexanalyzer.model.IssueData;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.collect.CloseableIterator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityExprList;
import org.ofbiz.core.entity.EntityOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DatabaseIssuesDataProvider {
    private final ProjectManager projectManager;
    private final OfBizDelegator ofBizDelegator;

    @Autowired
    public DatabaseIssuesDataProvider(@ComponentImport ProjectManager projectManager, @ComponentImport OfBizDelegator ofBizDelegator) {
        this.projectManager = Objects.requireNonNull(projectManager);
        this.ofBizDelegator = Objects.requireNonNull(ofBizDelegator);
    }

    public CloseableIterator<IssueData> getIssuesDataIterator() {
        Set<Long> archivedProjectsList = this.getArchivedProjectsIds();
        EntityExprList notArchivedIssuesCondition = this.getNotArchivedIssuesCondition();
        OfBizListIterator ofBizListIterator = this.ofBizDelegator.findListIteratorByCondition("Issue", (EntityCondition)notArchivedIssuesCondition, null, Arrays.asList(DBActiveIssuesIterator.REQUIRED_FIELDS), null, null);
        return new DBActiveIssuesIterator(ofBizListIterator, archivedProjectsList);
    }

    private EntityExprList getNotArchivedIssuesCondition() {
        EntityExpr notArchivedIssueCondition = new EntityExpr("archived", EntityOperator.EQUALS, (Object)DatabaseUtil.booleanToChar1((Boolean)false));
        EntityExpr nullInArchivedIssueCondition = new EntityExpr("archived", EntityOperator.EQUALS, null);
        return new EntityExprList(Arrays.asList(notArchivedIssueCondition, nullInArchivedIssueCondition), EntityOperator.OR);
    }

    private Set<Long> getArchivedProjectsIds() {
        return this.projectManager.getArchivedProjects().stream().map(Project::getId).collect(Collectors.toSet());
    }
}

