/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.indexanalyzer.model;

import com.atlassian.jira.plugins.indexanalyzer.model.IssueData;
import com.atlassian.jira.plugins.indexanalyzer.model.OutdatedIssueData;
import java.time.Instant;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class AnalyzerResult {
    @JsonProperty
    private final List<IssueData> indexOrphans;
    @JsonProperty
    private final List<IssueData> dbOrphans;
    @JsonProperty
    private final List<OutdatedIssueData> outdatedIssueData;
    @JsonProperty
    private final int okCount;
    private final transient int dbCount;
    @JsonProperty
    private final int outdatedCount;
    @JsonProperty
    private final int indexOrphansCount;
    @JsonProperty
    private final int dbOrphansCount;
    @JsonProperty
    private final long lastAnalyzeTimestamp;
    @JsonProperty
    private final float indexHealth;

    @JsonCreator
    public AnalyzerResult(@JsonProperty(value="indexOrphans") List<IssueData> indexOrphans, @JsonProperty(value="dbOrphans") List<IssueData> dbOrphans, @JsonProperty(value="outdatedIssueData") List<OutdatedIssueData> outdatedIssueData, @JsonProperty(value="okCount") int okCount, @JsonProperty(value="dbCount") int dbCount, @JsonProperty(value="outdatedCount") int outdatedCount, @JsonProperty(value="indexOrphansCount") int indexOrphansCount, @JsonProperty(value="dbOrphansCount") int dbOrphansCount) {
        this.indexOrphans = indexOrphans;
        this.dbOrphans = dbOrphans;
        this.outdatedIssueData = outdatedIssueData;
        this.okCount = okCount;
        this.dbCount = dbCount;
        this.outdatedCount = outdatedCount;
        this.indexOrphansCount = indexOrphansCount;
        this.dbOrphansCount = dbOrphansCount;
        this.indexHealth = (float)okCount * 100.0f / (float)dbCount;
        this.lastAnalyzeTimestamp = Instant.now().toEpochMilli();
    }

    public List<IssueData> getIndexOrphans() {
        return this.indexOrphans;
    }

    public List<IssueData> getDbOrphans() {
        return this.dbOrphans;
    }

    public List<OutdatedIssueData> getOutdatedIssueData() {
        return this.outdatedIssueData;
    }

    public int getOkCount() {
        return this.okCount;
    }

    public int getDbCount() {
        return this.dbCount;
    }

    public int getOutdatedIssueCount() {
        return this.outdatedCount;
    }

    public int getIndexOrphansCount() {
        return this.indexOrphansCount;
    }

    public int getDbOrphansCount() {
        return this.dbOrphansCount;
    }

    public float getIndexHealth() {
        return this.indexHealth;
    }

    public long getLastAnalyzeTimestamp() {
        return this.lastAnalyzeTimestamp;
    }
}

