/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestoreDataResources;
import com.atlassian.jira.testkit.client.dump.FuncTestTimer;
import com.atlassian.jira.testkit.client.dump.TestInformationKit;
import com.atlassian.jira.testkit.client.xmlbackup.XmlBackupCopier;
import com.atlassian.jira.testkit.util.ClasspathResources;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.commons.io.FilenameUtils;

public class DataImportControl
extends BackdoorControl<DataImportControl> {
    private static final Logger log = LoggerFactory.getLogger(DataImportControl.class);
    public static final String FS = System.getProperty("file.separator");
    public static final String IMPORT = "import";
    public static final String TESTKIT_XML_PACKAGE = "testkit/xmlresources";
    public static final String TESTKIT_BLANKPROJECTS = "testkit-blankprojects-";
    public static final String TESTKIT_BLANKPROJECTS_XML = "testkit/xmlresources/testkit-blankprojects-";
    public static final Pattern TESTKIT_BLANKPROJECTS_XML_PATTERN = Pattern.compile(".*testkit-blankprojects-(\\d+)\\.xml");
    private static final Iterable<Integer> REST_NOT_SETUP_ERROR_CODES = ImmutableList.of((Object)Response.Status.NOT_FOUND.getStatusCode(), (Object)Response.Status.SERVICE_UNAVAILABLE.getStatusCode());
    private static final ThreadLocal<ImportConfig> JIRA_CONFIG = new ThreadLocal();
    private static final ThreadLocal<List<Integer>> SUPPORTED_BUILD_NUMBERS = new ThreadLocal<List<Integer>>(){

        @Override
        protected List<Integer> initialValue() {
            Iterable matchingResources = ClasspathResources.getResources((String)DataImportControl.TESTKIT_XML_PACKAGE, (Pattern)TESTKIT_BLANKPROJECTS_XML_PATTERN);
            return Ordering.natural().sortedCopy(Iterables.transform((Iterable)matchingResources, this.toSupportedBuildNumber()));
        }

        private Function<String, Integer> toSupportedBuildNumber() {
            return new Function<String, Integer>(){

                public Integer apply(String name) {
                    Matcher matcher = TESTKIT_BLANKPROJECTS_XML_PATTERN.matcher(name);
                    if (matcher.matches()) {
                        return Integer.parseInt(matcher.group(1));
                    }
                    throw new IllegalStateException("Unexpected blank XML resource name: " + name);
                }
            };
        }
    };
    private JIRAEnvironmentData environmentData;
    private XmlBackupCopier xmlBackupCopier;

    public DataImportControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.environmentData = environmentData;
        this.xmlBackupCopier = new XmlBackupCopier(environmentData.getBaseUrl());
    }

    public boolean isSetUp() {
        try {
            this.get(this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("api").path("2").path("serverInfo"));
            return true;
        }
        catch (UniformInterfaceException interfaceException) {
            if (this.looksLikeNotSetup(interfaceException)) {
                return false;
            }
            throw new IllegalStateException("Unknown error when trying to check JIRA setup status", interfaceException);
        }
    }

    private boolean looksLikeNotSetup(UniformInterfaceException interfaceException) {
        return Iterables.contains(REST_NOT_SETUP_ERROR_CODES, (Object)interfaceException.getResponse().getStatus());
    }

    public void restoreBlankInstance() {
        this.restoreBlankInstance("\nAAABiQ0ODAoPeNp1kk9TwjAQxe/9FJnxXKYpeoCZHqCtgsqfgaIO4yWELURD0tm0KN/eWOjYdvD68\nvbtb3dzM9GKTBgS2iOU9n3a7/pkHiXE96jvbNhho3XnWXBQBuKtyIVWQTxN4sV8MV7GTirMHk5QO\nZJTBsG91eITvPdJBEeQOgN0uNRHwIYtLKWGa1ocNoCzdGUATUA9h2uVdhjPxRGCHAtw5gXyPTMQs\nRwCn1Lf9XzXv3NqwVN2gGCZDBYWstLj70zgqSyad0fVWPXgJaClGUfB8KGXuG+rl1v3ab0euUOPv\njofAlmD/XG8GJBY5YAZCtMa9Ze5MagVZAGKX/FVE4eyMDZtqrdgAq+19zJlWEr/Na0TXjkTx4KLj\nWzeKbyIjaAJE7aDYpa2tTSO+mvbCrBKo/ryate4Up9KfylnhjumhGEl0SCXzBjB1B9Q/QYhQulrH\n/fcue6svl1di8BwFFnZKAGTE3mGIalGksliJxTZVqTmvLF6fXxksjhzpkwaqP5s3fMDBMYhRDAtA\nhUAhcR3uL05YCxbclq7h1dNa+Nc+j4CFBrdN005oVlMN9yBlWeM4TlnrOhqX02j3");
    }

    public void restoreBlankInstance(String license) {
        String resource = this.findMatchingResource(this.getImportConfig().buildNumber);
        log.info("Restoring blank resource {}", (Object)resource);
        this.restoreDataFromResource(resource, license);
    }

    @VisibleForTesting
    protected String findMatchingResource(int buildNumber) {
        int index = Ordering.natural().binarySearch(SUPPORTED_BUILD_NUMBERS.get(), (Object)buildNumber);
        if (index >= 0) {
            return this.blankResourceForBuildNumber(index);
        }
        if (index == -1) {
            throw new IllegalStateException("The build number " + buildNumber + " is not supported");
        }
        return this.blankResourceForBuildNumber(-index - 2);
    }

    private String blankResourceForBuildNumber(int index) {
        return TESTKIT_BLANKPROJECTS_XML + SUPPORTED_BUILD_NUMBERS.get().get(index) + ".xml";
    }

    @Deprecated
    public void restoreData(String xmlFileName) {
        this.restoreData(xmlFileName, "\nAAABiQ0ODAoPeNp1kk9TwjAQxe/9FJnxXKYpeoCZHqCtgsqfgaIO4yWELURD0tm0KN/eWOjYdvD68\nvbtb3dzM9GKTBgS2iOU9n3a7/pkHiXE96jvbNhho3XnWXBQBuKtyIVWQTxN4sV8MV7GTirMHk5QO\nZJTBsG91eITvPdJBEeQOgN0uNRHwIYtLKWGa1ocNoCzdGUATUA9h2uVdhjPxRGCHAtw5gXyPTMQs\nRwCn1Lf9XzXv3NqwVN2gGCZDBYWstLj70zgqSyad0fVWPXgJaClGUfB8KGXuG+rl1v3ab0euUOPv\njofAlmD/XG8GJBY5YAZCtMa9Ze5MagVZAGKX/FVE4eyMDZtqrdgAq+19zJlWEr/Na0TXjkTx4KLj\nWzeKbyIjaAJE7aDYpa2tTSO+mvbCrBKo/ryate4Up9KfylnhjumhGEl0SCXzBjB1B9Q/QYhQulrH\n/fcue6svl1di8BwFFnZKAGTE3mGIalGksliJxTZVqTmvLF6fXxksjhzpkwaqP5s3fMDBMYhRDAtA\nhUAhcR3uL05YCxbclq7h1dNa+Nc+j4CFBrdN005oVlMN9yBlWeM4TlnrOhqX02j3");
    }

    @Deprecated
    public void restoreData(String xmlFileName, String license) {
        FuncTestTimer timer = TestInformationKit.pullTimer("XML Restore");
        String sourcePath = this.environmentData.getXMLDataLocation().getAbsolutePath() + FS + xmlFileName;
        String jiraImportPath = this.getJiraHomePath() + FS + IMPORT + FS + new File(xmlFileName).getName();
        boolean baseUrlReplaced = this.xmlBackupCopier.copyXmlBackupTo(sourcePath, jiraImportPath);
        DataImportBean importBean = new DataImportBean();
        importBean.filePath = jiraImportPath;
        importBean.licenseString = license;
        importBean.useDefaultPaths = false;
        importBean.quickImport = true;
        importBean.isSetup = false;
        if (baseUrlReplaced) {
            importBean.baseUrl = this.environmentData.getBaseUrl().toString();
        }
        this.createResource().path("dataImport").post(String.class, (Object)importBean);
        timer.end();
    }

    public void restoreDataFromResource(String resourcePath) {
        this.restoreDataFromResource(resourcePath, "\nAAABiQ0ODAoPeNp1kk9TwjAQxe/9FJnxXKYpeoCZHqCtgsqfgaIO4yWELURD0tm0KN/eWOjYdvD68\nvbtb3dzM9GKTBgS2iOU9n3a7/pkHiXE96jvbNhho3XnWXBQBuKtyIVWQTxN4sV8MV7GTirMHk5QO\nZJTBsG91eITvPdJBEeQOgN0uNRHwIYtLKWGa1ocNoCzdGUATUA9h2uVdhjPxRGCHAtw5gXyPTMQs\nRwCn1Lf9XzXv3NqwVN2gGCZDBYWstLj70zgqSyad0fVWPXgJaClGUfB8KGXuG+rl1v3ab0euUOPv\njofAlmD/XG8GJBY5YAZCtMa9Ze5MagVZAGKX/FVE4eyMDZtqrdgAq+19zJlWEr/Na0TXjkTx4KLj\nWzeKbyIjaAJE7aDYpa2tTSO+mvbCrBKo/ryate4Up9KfylnhjumhGEl0SCXzBjB1B9Q/QYhQulrH\n/fcue6svl1di8BwFFnZKAGTE3mGIalGksliJxTZVqTmvLF6fXxksjhzpkwaqP5s3fMDBMYhRDAtA\nhUAhcR3uL05YCxbclq7h1dNa+Nc+j4CFBrdN005oVlMN9yBlWeM4TlnrOhqX02j3");
    }

    public void restoreDataFromResource(String resourcePath, String license) {
        FuncTestTimer timer = TestInformationKit.pullTimer("XML Restore");
        String targetPath = this.getImportTargetPath(resourcePath);
        boolean baseUrlReplaced = this.xmlBackupCopier.copyXmlBackupFromClassPathTo(resourcePath, targetPath, Collections.<Pattern, String>emptyMap());
        DataImportBean importBean = new DataImportBean();
        importBean.filePath = targetPath;
        importBean.licenseString = license;
        importBean.useDefaultPaths = false;
        importBean.quickImport = true;
        importBean.isSetup = false;
        if (baseUrlReplaced) {
            importBean.baseUrl = this.environmentData.getBaseUrl().toString();
        }
        this.createResource().path("dataImport").post(String.class, (Object)importBean);
        timer.end();
    }

    private String getImportTargetPath(String resourcePath) {
        String importFileName = this.importFileNameFor((String)Preconditions.checkNotNull((Object)resourcePath));
        return this.getJiraHomePath() + FS + IMPORT + FS + importFileName;
    }

    private String getImportSourcePath(String resourcePath) {
        return RestoreDataResources.getResourceUrl(resourcePath).getFile();
    }

    private String importFileNameFor(String resourcePath) {
        String extension = FilenameUtils.getExtension(resourcePath);
        return extension != null ? resourcePath.hashCode() + "." + extension : resourcePath.hashCode() + ".xml";
    }

    public void turnOffDangerMode() {
        this.createResource().path("systemproperty").path("jira.dangermode").queryParam("value", "false").post();
    }

    public void turnOnDangerMode() {
        this.createResource().path("systemproperty").path("jira.dangermode").queryParam("value", "true").post();
    }

    private String getJiraHomePath() {
        return this.getImportConfig().jiraHome;
    }

    private ImportConfig getImportConfig() {
        ImportConfig config = JIRA_CONFIG.get();
        if (config == null) {
            config = (ImportConfig)this.createResource().path("dataImport/importConfig").get(ImportConfig.class);
            JIRA_CONFIG.set(config);
        }
        return config;
    }

    static class ImportConfig {
        public String jiraHome;
        public int buildNumber;

        ImportConfig() {
        }
    }

    static class DataImportBean {
        public String filePath;
        public String licenseString;
        public boolean quickImport;
        public boolean useDefaultPaths;
        public boolean isSetup;
        public String baseUrl;

        DataImportBean() {
        }
    }
}

