/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.CommentClient;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import com.atlassian.jira.util.collect.MapBuilder;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

public class IssuesControl
extends BackdoorControl<IssuesControl> {
    public static final long HSP_PROJECT_ID = 10000L;
    public static final long MKY_PROJECT_ID = 10001L;
    private IssueClient issueClient;
    private CommentClient commentClient;

    public IssuesControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.issueClient = new IssueClient(environmentData);
        this.commentClient = new CommentClient(environmentData);
    }

    public IssueCreateResponse createIssue(long projectId, String summary) {
        return this.createIssue(projectId, summary, null);
    }

    public IssueCreateResponse createSubtask(String projectId, String parentKey, String summary) {
        IssueFields fields = new IssueFields();
        fields.project(ResourceRef.withId((String)("" + projectId)));
        fields.parent(ResourceRef.withKey((String)parentKey));
        fields.issueType(ResourceRef.withId((String)"5"));
        fields.priority(ResourceRef.withId((String)"1"));
        fields.summary(summary);
        IssueUpdateRequest issue = new IssueUpdateRequest();
        return this.issueClient.create(issue.fields(fields));
    }

    public IssueCreateResponse createIssue(String projectKey, String summary) {
        return this.createIssue(projectKey, summary, null);
    }

    public IssuesControl setDescription(String issueKey, String description) {
        IssueUpdateRequest fields = new IssueUpdateRequest().fields(new IssueFields().description(description));
        this.issueClient.update(issueKey, fields);
        return this;
    }

    public IssueCreateResponse createIssue(long projectId, String summary, String assignee) {
        IssueFields fields = new IssueFields();
        fields.project(ResourceRef.withId((String)("" + projectId)));
        fields.issueType(ResourceRef.withId((String)"1"));
        fields.priority(ResourceRef.withId((String)"1"));
        if (assignee != null) {
            fields.assignee(ResourceRef.withName((String)assignee));
        }
        fields.summary(summary);
        IssueUpdateRequest issue = new IssueUpdateRequest();
        return this.issueClient.create(issue.fields(fields));
    }

    public IssueCreateResponse createIssue(String projectKey, String summary, String assignee) {
        IssueFields fields = new IssueFields();
        fields.project(ResourceRef.withKey((String)projectKey));
        fields.issueType(ResourceRef.withId((String)"1"));
        fields.priority(ResourceRef.withId((String)"1"));
        if (assignee != null) {
            fields.assignee(ResourceRef.withName((String)assignee));
        }
        fields.summary(summary);
        IssueUpdateRequest issue = new IssueUpdateRequest();
        return this.issueClient.create(issue.fields(fields));
    }

    public Response<Comment> commentIssue(String issueKey, String comment) {
        Comment newComment = new Comment();
        newComment.body = comment;
        newComment.visibility = new Visibility("group", "jira-administrators");
        return this.commentClient.post(issueKey, newComment);
    }

    public void assignIssue(String issueKey, String username) {
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().fields(new IssueFields().assignee(ResourceRef.withName((String)username)));
        this.issueClient.update(issueKey, updateSummaryRequest);
    }

    public Issue getIssue(String issueKey, Issue.Expand ... expand) {
        return this.issueClient.get(issueKey, expand);
    }

    public IssuesControl addLabel(String issueKey, String label) {
        Map add = MapBuilder.newBuilder().add((Object)"add", (Object)label).toMap();
        List<Map> addList = Collections.singletonList(add);
        Map labels = MapBuilder.newBuilder().add((Object)"labels", addList).toMap();
        Map update = MapBuilder.newBuilder().add((Object)"update", (Object)labels).toMap();
        Response response = this.issueClient.update(issueKey, update);
        Assert.assertTrue((String)("Update failed. " + response.toString()), (response.statusCode == 204 ? 1 : 0) != 0);
        return this;
    }

    public IssuesControl setSummary(String issueKey, String summary) {
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().fields(new IssueFields().summary(summary));
        Response response = this.issueClient.updateResponse(issueKey, updateSummaryRequest);
        Assert.assertTrue((String)("Update failed. " + response.toString()), (response.statusCode == 204 ? 1 : 0) != 0);
        return this;
    }

    public IssuesControl setIssueFields(String issueKey, IssueFields issueFields) {
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(issueFields);
        Response response = this.issueClient.updateResponse(issueKey, updateRequest);
        Assert.assertTrue((String)("Update failed. " + response.toString()), (response.statusCode == 204 ? 1 : 0) != 0);
        return this;
    }

    public Response deleteIssue(String issueKey, boolean deleteSubtasks) throws UniformInterfaceException {
        return this.issueClient.delete(issueKey, Boolean.toString(deleteSubtasks));
    }

    @Override
    public IssuesControl loginAs(String username) {
        this.issueClient.loginAs(username);
        return (IssuesControl)super.loginAs(username);
    }

    @Override
    public IssuesControl loginAs(String username, String password) {
        this.issueClient.loginAs(username, password);
        return (IssuesControl)super.loginAs(username, password);
    }

    public Issue getIssue(String key) {
        return this.issueClient.get(key, new Issue.Expand[0]);
    }
}

