/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;

public class PermissionSchemesControl
extends BackdoorControl<PermissionSchemesControl> {
    public PermissionSchemesControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Long copyDefaultScheme(String schemeName) {
        return Long.parseLong((String)this.createResource().path("permissionSchemes/copyDefault").queryParam("schemeName", schemeName).get(String.class));
    }

    public Long createScheme(String schemeName, String description) {
        return Long.parseLong((String)this.createResource().path("permissionSchemes/create").queryParam("schemeName", schemeName).queryParam("schemeDescription", description).get(String.class));
    }

    public void deleteScheme(long schemeId) {
        this.createResource().path("permissionSchemes").path(String.valueOf(schemeId)).delete();
    }

    public void addGroupPermission(Long schemeId, int permission, String groupName) {
        this.addPermission(schemeId, permission, "group", groupName);
    }

    public void removeGroupPermission(long schemeId, int permission, String groupName) {
        this.removePermission(schemeId, permission, "group", groupName);
    }

    public void addProjectRolePermission(long schemeId, int permission, long projectRoleId) {
        this.addPermission(schemeId, permission, "projectrole", Long.toString(projectRoleId));
    }

    public void removeProjectRolePermission(long schemeId, int permission, long projectRoleId) {
        this.removePermission(schemeId, permission, "projectrole", Long.toString(projectRoleId));
    }

    public void addUserPermission(long schemeId, int permission, String userName) {
        this.addPermission(schemeId, permission, "user", userName);
    }

    public void removeUserPermission(long schemeId, int permission, String userName) {
        this.removePermission(schemeId, permission, "user", userName);
    }

    public void replaceGroupPermissions(long schemeId, int permission, String groupName) {
        this.replacePermissions(schemeId, permission, "group", groupName);
    }

    private void addPermission(long schemeId, int permission, String type, String parameter) {
        this.get(this.createResource().path("permissionSchemes/entity/add").queryParam("schemeId", "" + schemeId).queryParam("permission", "" + permission).queryParam("type", type).queryParam("parameter", parameter));
    }

    private void removePermission(long schemeId, int permission, String type, String parameter) {
        this.get(this.createResource().path("permissionSchemes/entity/remove").queryParam("schemeId", "" + schemeId).queryParam("permission", "" + permission).queryParam("type", type).queryParam("parameter", parameter));
    }

    private void replacePermissions(long schemeId, int permission, String type, String parameter) {
        this.get(this.createResource().path("permissionSchemes/entity/replace").queryParam("schemeId", "" + schemeId).queryParam("permission", "" + permission).queryParam("type", type).queryParam("parameter", parameter));
    }
}

