/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.beans.EntityList;
import com.atlassian.jira.testkit.beans.ProjectSchemesBean;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.sun.jersey.api.client.WebResource;

public class ProjectControl
extends BackdoorControl<ProjectControl> {
    public ProjectControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public long addProject(String name, String key, String lead) {
        String s = (String)this.createResource().path("project/add").queryParam("name", name).queryParam("key", key).queryParam("lead", lead).get(String.class);
        return Long.parseLong(s);
    }

    public void deleteProject(String key) {
        this.createResource().path("project").path(key).delete();
    }

    public void setPermissionScheme(long projectId, long schemeId) {
        this.get(this.createResource().path("project/permissionScheme/set").queryParam("project", "" + projectId).queryParam("scheme", "" + schemeId));
    }

    public void setNotificationScheme(long projectId, Long schemeId) {
        WebResource r = this.createResource().path("project/notificationScheme/set").queryParam("project", "" + projectId);
        if (schemeId != null) {
            r = r.queryParam("scheme", "" + schemeId);
        }
        this.get(r);
    }

    public void setIssueSecurityScheme(long projectId, Long schemeId) {
        WebResource r = this.createResource().path("project/issueSecurityScheme/set").queryParam("project", "" + projectId);
        if (schemeId != null) {
            r = r.queryParam("scheme", "" + schemeId);
        }
        this.get(r);
    }

    public void addFieldConfigurationScheme(long projectId, long schemeId) {
        this.get(this.createResource().path("project/fieldConfigurationScheme/add").queryParam("project", "" + projectId).queryParam("scheme", "" + schemeId));
    }

    public void removeFieldConfigurationScheme(long projectId, long schemeId) {
        this.get(this.createResource().path("project/fieldConfigurationScheme/remove").queryParam("project", "" + projectId).queryParam("scheme", "" + schemeId));
    }

    public void setIssueTypeScreenScheme(long projectId, long issueTypeScreenSchemeId) {
        this.get(this.createResource().path("project/issueTypeScreenScheme/set").queryParam("project", "" + projectId).queryParam("issueTypeScreenScheme", "" + issueTypeScreenSchemeId));
    }

    public void setDefaultIssueType(long projectId, String issueTypeId) {
        WebResource resource = this.createResource().path("project/defaultIssueType/set").queryParam("project", "" + projectId);
        if (issueTypeId != null) {
            resource = resource.queryParam("issueTypeId", "" + issueTypeId);
        }
        this.get(resource);
    }

    public void setProjectLead(long projectId, String username) {
        WebResource resource = this.createResource().path("project/projectLead/set").queryParam("project", "" + projectId).queryParam("username", "" + username);
        this.get(resource);
    }

    public void setProjectDefaultAssignee(long projectId, boolean setToProjectLead) {
        WebResource resource = this.createResource().path("project/defaultAssignee/set").queryParam("project", "" + projectId).queryParam("setToProjectLead", "" + setToProjectLead);
        this.get(resource);
    }

    public ProjectSchemesBean getSchemes(Long projectId) {
        return this.getSchemes(Long.toString(projectId));
    }

    public ProjectSchemesBean getSchemes(String projectIdOrKey) {
        return (ProjectSchemesBean)this.createProjectSchemesResource(projectIdOrKey).get(ProjectSchemesBean.class);
    }

    private WebResource createProjectSchemesResource(String projectIdOrKey) {
        return this.createResource().path("project").path(projectIdOrKey).path("schemes");
    }

    public EntityList getEntityLinks(Long projectId) {
        return (EntityList)this.createResource().path("applinks").path("entitylinks").queryParam("projectId", Long.toString(projectId)).get(EntityList.class);
    }
}

