/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.ComponentIssueCounts;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import javax.ws.rs.core.MediaType;

public class ComponentClient
extends RestApiClient<ComponentClient> {
    public ComponentClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Component get(String componentID) throws UniformInterfaceException {
        return (Component)this.componentWithId(componentID).get(Component.class);
    }

    public Response getResponse(final String componentID) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)ComponentClient.this.componentWithId(componentID).get(ClientResponse.class);
            }
        });
    }

    protected WebResource componentWithId(String componentID) {
        return this.createResource().path("component").path(componentID);
    }

    public Component create(Component component) {
        try {
            return (Component)this.component().post(Component.class, (Object)component);
        }
        catch (UniformInterfaceException e) {
            throw new RuntimeException("Failed to create component: " + this.errorResponse(e.getResponse()), e);
        }
    }

    public Response createResponse(final Component component) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)ComponentClient.this.component().post(ClientResponse.class, (Object)component);
            }
        });
    }

    public Response putResponse(final String componentId, final Component component) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)ComponentClient.this.componentWithId(componentId).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)component);
            }
        });
    }

    public Response putResponse(Component component) {
        String[] selfParts = component.self.split("/");
        String componentId = selfParts[selfParts.length - 1];
        return this.putResponse(componentId, component);
    }

    public ComponentIssueCounts getComponentIssueCounts(String componentId) throws UniformInterfaceException {
        return (ComponentIssueCounts)this.componentWithId(componentId).path("relatedIssueCounts").get(ComponentIssueCounts.class);
    }

    public Response getComponentIssueCountsResponse(final String componentId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)ComponentClient.this.componentWithId(componentId).path("relatedIssueCounts").get(ClientResponse.class);
            }
        });
    }

    public Response delete(String componentId) throws UniformInterfaceException {
        return this.delete(componentId, null);
    }

    public Response delete(final String componentId, final URI swapComponent) throws UniformInterfaceException {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                WebResource deleteResource = ComponentClient.this.componentWithId(componentId);
                if (swapComponent != null) {
                    deleteResource = deleteResource.queryParam("moveIssuesTo", swapComponent.getPath());
                }
                return (ClientResponse)deleteResource.delete(ClientResponse.class);
            }
        });
    }

    private WebResource.Builder component() {
        return this.createResource().path("component").type(MediaType.APPLICATION_JSON_TYPE);
    }
}

