/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.rest.api.dashboard.DashboardBean;
import com.atlassian.jira.rest.api.dashboard.DashboardsBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import javax.annotation.Nullable;

public class DashboardClient
extends RestApiClient<DashboardClient> {
    public DashboardClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public DashboardClient(JIRAEnvironmentData environmentData, String version) {
        super(environmentData, version);
    }

    public DashboardBean getSingle(String dashboardId) {
        try {
            return (DashboardBean)this.createResource().path("dashboard").path(dashboardId).get(DashboardBean.class);
        }
        catch (UniformInterfaceException e) {
            throw new RuntimeException("Failed to get list of dashboards: " + this.errorResponse(e.getResponse()), e);
        }
    }

    public Response getSingleResponse(final String dashboardId) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)DashboardClient.this.createResource().path("dashboard").path(dashboardId).get(ClientResponse.class);
            }
        });
    }

    public DashboardsBean getList(@Nullable String filter, @Nullable Integer startAt, @Nullable Integer maxResults) {
        try {
            WebResource resource = this.createResource(filter, startAt, maxResults);
            return (DashboardsBean)resource.get(DashboardsBean.class);
        }
        catch (UniformInterfaceException e) {
            throw new RuntimeException("Failed to get list of dashboards: " + this.errorResponse(e.getResponse()), e);
        }
    }

    public Response getListResponse(final String filter, final Integer startAt, final Integer maxResults) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)DashboardClient.this.createResource(filter, startAt, maxResults).get(ClientResponse.class);
            }
        });
    }

    private WebResource createResource(String filter, Integer startAt, Integer maxResults) {
        WebResource resource = this.createResource().path("dashboard");
        if (filter != null) {
            resource = resource.queryParam("filter", filter);
        }
        if (startAt != null) {
            resource = resource.queryParam("startAt", String.valueOf(startAt));
        }
        if (maxResults != null) {
            resource = resource.queryParam("maxResults", String.valueOf(maxResults));
        }
        return resource;
    }
}

