/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Avatar;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import java.util.Map;

public class ProjectClient
extends RestApiClient<ProjectClient> {
    public ProjectClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Project get(String projectKey) throws UniformInterfaceException {
        return (Project)this.projectWithKey(projectKey).get(Project.class);
    }

    public List<Project> getProjects() {
        return (List)this.projects().get(Project.PROJECTS_TYPE);
    }

    public List<Version> getVersions(String key) {
        return (List)this.projectVersionWithKey(key).get(Version.VERSIONS_TYPE);
    }

    public Map<String, List<Avatar>> getAvatars(String key) {
        return (Map)this.projectWithKey(key).path("avatars").get(Avatar.ALLAVATARS_TYPE);
    }

    public Avatar getAvatar(String key, Long id) {
        return (Avatar)this.projectWithKey(key).path("avatar").path(id.toString()).get(Avatar.AVATAR_TYPE);
    }

    public Response getResponse(final String projectKey) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)ProjectClient.this.projectWithKey(projectKey).get(ClientResponse.class);
            }
        });
    }

    public Response getVersionsResponse(final String projectKey) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)ProjectClient.this.projectWithKey(projectKey).get(ClientResponse.class);
            }
        });
    }

    public List<Component> getComponents(String key) {
        return (List)this.projectComponentWithKey(key).get(Component.COMPONENTS_TYPE);
    }

    protected WebResource projectWithKey(String projectKey) {
        return this.createResource().path("project").path(projectKey);
    }

    protected WebResource projectVersionWithKey(String projectKey) {
        return this.createResource().path("project").path(projectKey).path("versions");
    }

    protected WebResource projectComponentWithKey(String projectKey) {
        return this.createResource().path("project").path(projectKey).path("components");
    }

    protected WebResource projects() {
        return this.createResource().path("project");
    }
}

