/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.UserPickerResults;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class UserClient
extends RestApiClient<UserClient> {
    public UserClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public User get(String username, User.Expand ... expand) {
        return (User)this.userWithUsername(username, UserClient.setOf(User.Expand.class, (Enum[])expand)).get(User.class);
    }

    public User getByKey(String key, User.Expand ... expand) {
        return (User)this.userWithKey(key, UserClient.setOf(User.Expand.class, (Enum[])expand)).get(User.class);
    }

    public List<User> searchAssignable(String query, String issueKey, String startAt, String maxResults) {
        WebResource resource = this.getSearchAssignableResource(query, issueKey, startAt, maxResults);
        return Arrays.asList((Object[])resource.get(User[].class));
    }

    public List<User> multiProjectSearchAssignable(String query, String projectKeys, String startAt, String maxResults) {
        WebResource resource = this.getMultiProjectSearchAssignableResource(query, projectKeys, startAt, maxResults);
        return Arrays.asList((Object[])resource.get(User[].class));
    }

    public List<User> searchViewableIssue(String query, String issueKey, String startAt, String maxResults) {
        WebResource resource = this.getSearchViewableIssueResource(query, issueKey, startAt, maxResults);
        return Arrays.asList((Object[])resource.get(User[].class));
    }

    public List<User> search(String query, String startAt, String maxResults) {
        WebResource resource = this.getSearchResource(query, startAt, maxResults, null, null);
        return Arrays.asList((Object[])resource.get(User[].class));
    }

    public List<User> search(String query, String startAt, String maxResults, Boolean includeActive, Boolean includeInactive) {
        WebResource resource = this.getSearchResource(query, startAt, maxResults, includeActive, includeInactive);
        return Arrays.asList((Object[])resource.get(User[].class));
    }

    public UserPickerResults picker(String query, String maxResults) {
        WebResource resource = this.getPickerResource(query, maxResults);
        return (UserPickerResults)resource.get(UserPickerResults.class);
    }

    public WebResource getSearchAssignableResource(String query, String issueKey, String startAt, String maxResults) {
        WebResource resource = this.applyPagingParams(query, startAt, maxResults, this.createResource().path("user").path("assignable").path("search"));
        resource = resource.queryParam("issueKey", issueKey);
        return resource;
    }

    public WebResource getMultiProjectSearchAssignableResource(String query, String projectKeys, String startAt, String maxResults) {
        WebResource resource = this.applyPagingParams(query, startAt, maxResults, this.createResource().path("user").path("assignable").path("multiProjectSearch"));
        resource = resource.queryParam("projectKeys", projectKeys);
        return resource;
    }

    public WebResource getSearchViewableIssueResource(String query, String issueKey, String startAt, String maxResults) {
        WebResource resource = this.applyPagingParams(query, startAt, maxResults, this.createResource().path("user").path("viewissue").path("search"));
        resource = resource.queryParam("issueKey", issueKey);
        return resource;
    }

    public WebResource getSearchResource(String query, String startAt, String maxResults, Boolean includeActive, Boolean includeInactive) {
        WebResource resource = this.applyPagingParams(query, startAt, maxResults, this.createResource().path("user").path("search"));
        if (includeActive != null) {
            resource = resource.queryParam("includeActive", includeActive.toString());
        }
        if (includeInactive != null) {
            resource = resource.queryParam("includeInactive", includeInactive.toString());
        }
        return resource;
    }

    public WebResource getPickerResource(String query, String maxResults) {
        WebResource resource = this.createResource().path("user").path("picker");
        if (StringUtils.isNotBlank((String)query)) {
            resource = resource.queryParam("query", query);
        }
        if (StringUtils.isNotBlank((String)maxResults)) {
            resource = resource.queryParam("maxResults", maxResults);
        }
        return resource;
    }

    private WebResource applyPagingParams(String query, String startAt, String maxResults, WebResource resource) {
        resource = resource.queryParam("username", query);
        if (StringUtils.isNotBlank((String)startAt)) {
            resource = resource.queryParam("startAt", startAt);
        }
        if (StringUtils.isNotBlank((String)maxResults)) {
            resource = resource.queryParam("maxResults", maxResults);
        }
        return resource;
    }

    public Response getUserResponse(String username) {
        return this.getResponse(this.userWithUsername(username, UserClient.setOf(User.Expand.class, (Enum[])new User.Expand[0])));
    }

    public Response getUserResponseByKey(String key) {
        return this.getResponse(this.userWithKey(key, UserClient.setOf(User.Expand.class, (Enum[])new User.Expand[0])));
    }

    public Response getResponse(final WebResource resource) {
        return this.toResponse(new RestApiClient.Method(){

            @Override
            public ClientResponse call() {
                return (ClientResponse)resource.get(ClientResponse.class);
            }
        });
    }

    private WebResource userWithUsername(String username, EnumSet<User.Expand> expands) {
        WebResource result = this.createResource().path("user");
        if (username != null) {
            result = result.queryParam("username", UserClient.percentEncode(username));
        }
        return this.expanded(result, expands);
    }

    private WebResource userWithKey(String key, EnumSet<User.Expand> expands) {
        WebResource result = this.createResource().path("user");
        if (key != null) {
            result = result.queryParam("key", UserClient.percentEncode(key));
        }
        return this.expanded(result, expands);
    }
}

