/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.rules;

import com.atlassian.jira.testkit.client.Backdoor;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import org.junit.rules.ExternalResource;

public class EnableDarkFeatureRule
extends ExternalResource {
    private final ImmutableList<Backdoor> jiras;
    private final String feature;
    private boolean disableAfter = false;

    public <T extends Backdoor> EnableDarkFeatureRule(@Nonnull String s, T ... jiras) {
        this.feature = s;
        this.jiras = ImmutableList.copyOf((Object[])jiras);
    }

    public EnableDarkFeatureRule andDisableAfter() {
        this.disableAfter = true;
        return this;
    }

    protected void before() throws Throwable {
        super.before();
        for (Backdoor jira : this.jiras) {
            jira.darkFeatures().enableForSite(this.feature);
        }
    }

    protected void after() {
        if (this.disableAfter) {
            for (Backdoor jira : this.jiras) {
                jira.darkFeatures().disableForSite(this.feature);
            }
        }
        super.after();
    }
}

