/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraWebResourceCacheFlushingAccessor {
    private static Logger log = LoggerFactory.getLogger(JiraWebResourceCacheFlushingAccessor.class);

    public static void flushWebResourcesIfJiraPresent() {
        if (JiraWebResourceCacheFlushingAccessor.isJiraPresent()) {
            LookAndFeelBean lookAndFeelBean = JiraWebResourceCacheFlushingAccessor.getJiraLookAndFeelBean();
            JiraWebResourceCacheFlushingAccessor.getJiraLookAndFeelBean().updateVersion(lookAndFeelBean.getVersion());
            JiraSystemProperties.getInstance().refresh();
            JiraWebResourceCacheFlushingAccessor.flushWebResourceAssemblerFactory();
        }
    }

    private static LookAndFeelBean getJiraLookAndFeelBean() {
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        return LookAndFeelBean.getInstance((ApplicationProperties)applicationProperties);
    }

    private static boolean isJiraPresent() {
        try {
            Class.forName("com.atlassian.jira.config.properties.LookAndFeelBean");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void flushWebResourceAssemblerFactory() {
        ReflectiveOperationException ex = null;
        try {
            WebResourceAssemblerFactory webResourceAssemblerFactory = (WebResourceAssemblerFactory)ComponentAccessor.getComponent(WebResourceAssemblerFactory.class);
            Method clearCacheMethod = WebResourceAssemblerFactory.class.getMethod("clearCache", new Class[0]);
            clearCacheMethod.invoke((Object)webResourceAssemblerFactory, new Object[0]);
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        catch (NoSuchMethodException e) {
            ex = e;
        }
        if (ex != null) {
            log.warn("Failed to call WebResourceAssemblerFactory#clearCache() reflectively. This can be ignored for earlier versions of JIRA");
        }
    }
}

