/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lucenelegacy;

public class NumericUtils {
    public static final char SHIFT_START_LONG = ' ';
    public static final int BUF_SIZE_LONG = 11;

    public static int longToPrefixCoded(long val, int shift, char[] buffer) {
        if (shift > 63 || shift < 0) {
            throw new IllegalArgumentException("Illegal shift value, must be 0..63");
        }
        int nChars = (63 - shift) / 7 + 1;
        int len = nChars + 1;
        buffer[0] = (char)(32 + shift);
        long sortableBits = val ^ Long.MIN_VALUE;
        sortableBits >>>= shift;
        while (nChars >= 1) {
            buffer[nChars--] = (char)(sortableBits & 0x7FL);
            sortableBits >>>= 7;
        }
        return len;
    }

    public static String longToPrefixCoded(long val, int shift) {
        char[] buffer = new char[11];
        int len = NumericUtils.longToPrefixCoded(val, shift, buffer);
        return new String(buffer, 0, len);
    }

    public static String longToPrefixCoded(long val) {
        return NumericUtils.longToPrefixCoded(val, 0);
    }

    public static long prefixCodedToLong(String prefixCoded) {
        int shift = prefixCoded.charAt(0) - 32;
        if (shift > 63 || shift < 0) {
            throw new NumberFormatException("Invalid shift value in prefixCoded string (is encoded value really a LONG?)");
        }
        long sortableBits = 0L;
        int len = prefixCoded.length();
        for (int i = 1; i < len; ++i) {
            sortableBits <<= 7;
            char ch = prefixCoded.charAt(i);
            if (ch > '\u007f') {
                throw new NumberFormatException("Invalid prefixCoded numerical value representation (char " + Integer.toHexString(ch) + " at position " + i + " is invalid)");
            }
            sortableBits |= (long)ch;
        }
        return sortableBits << shift ^ Long.MIN_VALUE;
    }

    public static String doubleToPrefixCoded(double val) {
        return NumericUtils.longToPrefixCoded(org.apache.lucene.util.NumericUtils.doubleToSortableLong((double)val));
    }
}

