/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lucenelegacy.sort;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.FieldComparator;

public class LongComparator
extends FieldComparator.NumericComparator<Long> {
    private long[] values;
    private long bottom;
    private long topValue;
    private final int numHits;

    public LongComparator(int numHits, String field, Long missingValue) {
        super(field, (Number)(missingValue != null ? missingValue : 0L));
        this.numHits = numHits;
        this.values = new long[numHits];
    }

    private long getValueForDoc(int doc) throws IOException {
        if (this.currentReaderValues.advanceExact(doc)) {
            return this.currentReaderValues.longValue();
        }
        return (Long)this.missingValue;
    }

    public int compare(int slot1, int slot2) {
        return Long.compare(this.values[slot1], this.values[slot2]);
    }

    public int compareBottom(int doc) throws IOException {
        return Long.compare(this.bottom, this.getValueForDoc(doc));
    }

    private void ensureCapacity(int slot) {
        if (this.values.length <= slot) {
            int newSize = Math.min(this.numHits, slot * 2);
            this.values = Arrays.copyOf(this.values, newSize);
        }
    }

    public void copy(int slot, int doc) throws IOException {
        this.ensureCapacity(slot);
        this.values[slot] = this.getValueForDoc(doc);
    }

    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public void setTopValue(Long value) {
        this.topValue = value;
    }

    public Long value(int slot) {
        return this.values[slot];
    }

    public int compareTop(int doc) throws IOException {
        return Long.compare(this.topValue, this.getValueForDoc(doc));
    }
}

